package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.OrderCargoBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.ItemInventoryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.param.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author shuidi
 */
@Api(tags = {"inventory接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}", path = "/v1/inventory", url = "${yundt.cube.center.inventory.api:}")
public interface ITcbjInventoryApi {

    @PostMapping(value = "/queryCargoStorage", produces = "application/json")
    @ApiOperation(value = "前端 分页查询货品库存", notes = "分页查询货品库存")
    RestResponse<PageInfo<CargoStorageDto>> queryCargoStorage(@Validated @RequestBody CargoStorageDto queryDto);

    @PostMapping(value = "/queryBatchByActivity", produces = "application/json")
    @ApiOperation(value = "前端 分页查询批次号", notes = "分页查询批次号")
    RestResponse<PageInfo<CargoStorageDto>> queryBatchByActivity(@Validated @RequestBody TcbjCombinationBatchReqDto queryDto);

    @PostMapping(value = "/queryBatch", produces = "application/json")
    @ApiOperation(value = "前端 分页查询批次号", notes = "分页查询批次号")
    RestResponse<PageInfo<CargoStorageDto>> queryBatch(@Validated @RequestBody CargoStorageDto queryDto);

    @Deprecated
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "前端 分页查询库存", notes = "分页查询")
    RestResponse<PageInfo<TcbjInventoryRespDto>> page(@Validated @RequestBody TcbjInventoryReqDto queryDto);

    @Deprecated
    @PostMapping(value = "/log", produces = "application/json")
    @ApiOperation(value = "前端 分页查询库存流水", notes = "分页查询")
    RestResponse<PageInfo<TcbjInventoryLogRespDto>> log(@Validated @RequestBody TcbjInventoryLogReqDto queryDto);

    @Deprecated
    @PostMapping(value = "/preOccupy", produces = "application/json")
    @ApiOperation(value = "营销云 库存预占", notes = "库存预占")
    RestResponse<String> preOccupy(@Validated @RequestBody TcbjProOccupyReqDto tcbjProOccupyReqDto);

    @Deprecated
    @PostMapping(value = "/cancelPreOccupy", produces = "application/json")
    @ApiOperation(value = "营销云 释放库存预占", notes = "释放库存预占")
    RestResponse<String> cancelPreOccupy(@Validated @RequestBody String json);

    @Deprecated
    @PostMapping(value = "/cancelPreOccupyJson", produces = "application/json")
    @ApiOperation(value = "营销云 释放库存预占", notes = "释放库存预占")
    RestResponse<String> cancelPreOccupyJson(@Validated @RequestBody TcbjCancelOccupyReqDto reqDto);

    @PostMapping(value = "/preOccupyList", produces = "application/json")
    @ApiOperation(value = "前端 库存预占查看", notes = "库存预占查看")
    RestResponse<PageInfo<TcbjProOccupyRespDto>> preOccupyList(@Validated @RequestBody TcbjProOccupyListReqDto queryDto);

    /**
     * 给营销云用的
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/avilableYingXiaoYun", produces = "application/json")
    @ApiOperation(value = "前端 库存预占查看", notes = "库存预占查看")
    RestResponse<List<TcbjAvilableRespDto>> avilable(@Validated @RequestBody TcbjAvilableReqDto queryDto);

    /**
     * 给前端用的
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/avilable/sale", produces = "application/json")
    @ApiOperation(value = "营销云 库存预占查看", notes = "库存预占查看")
    RestResponse<List<TcbjAvilableRespDto>> avilableYingXiaoYun(@Validated @RequestBody TcbjAvilableReqDto queryDto);

    @PostMapping(value = "/adjust", produces = "application/json")
    @ApiOperation(value = "营销云 库存盘点", notes = "库存盘点")
    RestResponse<String> adjust(@Validated @RequestBody TcbjCompareReqDto queryDto);

    @Deprecated
    @GetMapping(value = "/diff", produces = "application/json")
    @ApiOperation(value = "定时任务 对比营销云库存", notes = "对比营销云库存")
    RestResponse<String> diff();

    @Deprecated
    @PostMapping({"/list/branch"})
    @ApiOperation(value = "批量查询库存信息", notes = "批量查询库存信息")
    RestResponse<List<ItemInventoryQueryRespDto>> queryBranchItemStorage(@RequestBody List<String> itemCodeList);

    @Deprecated
    @GetMapping({"/return-audit-order-status"})
    @ApiOperation(value = "反审核变更状态", notes = "反审核变更状态")
    RestResponse<String> returnAuditOrderStatus(@RequestParam(value = "preNo") String preNo);

    @Deprecated
    @GetMapping({"/change-order-status"})
    @ApiOperation(value = "变更状态", notes = "变更状态")
    RestResponse<String> changeOrderStatus(@RequestParam(value = "preNo") String preNo,@RequestParam(value = "orderStatus") Integer orderStatus);

    @Deprecated
    @PostMapping({"/update-noti-batch"})
    @ApiOperation(value = "修改通知单批次", notes = "修改通知单批次")
    void updateNotiBatch(@RequestBody List<OrderCargoBatchReqDto> orderCargoBatchReqDto);

    /**
     * 组合套装商品，库存预占接口
     *
     * @param combinationActReqDto
     * @return
     */
    @PostMapping(value = "/combinationActPreempt", produces = "application/json")
    @ApiOperation(value = "组合套装商品，库存预占接口", notes = "组合套装商品，库存预占接口")
    RestResponse<Void> combinationActPreempt(@Validated @RequestBody TcbjCombinationActReqDto combinationActReqDto);

    /**
     * 组合套装商品，活动结束，返还库存
     *
     * @param combinationActBacktrackReqDto
     * @return
     */
    @PostMapping(value = "/backtrackInventory", produces = "application/json")
    @ApiOperation(value = " 组合套装商品，活动结束，返还库存", notes = " 组合套装商品，活动结束，返还库存")
    RestResponse<Void> backtrackInventory(@RequestBody TcbjCombinationActBacktrackReqDto combinationActBacktrackReqDto);

    /**
     * 组合套装活动商品，库存查询
     *
     * @param inventoryActReqDto
     * @return
     */
    @PostMapping(value = "/inventoryActQuery", produces = "application/json")
    @ApiOperation(value = "组合套装活动商品，库存查询", notes = "组合套装活动商品，库存查询")
    RestResponse<List<TcbjInventoryActRespDto>> inventoryActQuery(@Validated @RequestBody TcbjInventoryActReqDto inventoryActReqDto);

    /**
     * 活动库存流水分页查询
     *
     * @param inventoryActLogReqDto
     * @return
     */
    @Deprecated
    @PostMapping(value = "/inventoryActLogPageQuery", produces = "application/json")
    @ApiOperation(value = "活动库存流水分页查询", notes = "活动库存流水分页查询")
    RestResponse<PageInfo<TbjcInventoryActLogRespDto>> inventoryActLogPageQuery(@Validated @RequestBody TcbjInventoryActLogReqDto inventoryActLogReqDto);

    /**
     * 创建发货通知单
     * @param orderNo 订单号
     * @return 请求结果
     */
    @GetMapping(value = "/createDeliverInformOrder")
    @ApiOperation(value = "创建发货通知单", notes = "创建发货通知单")
    RestResponse<Void> createDeliverInformOrder(@RequestParam(name = "orderNo") String orderNo);

    /**
     * 根据批次号集合、仓库编码查询货品库存
     * @param batchList 批次号集合
     * @param warehouseCode 仓库编码
     * @return
     */
    @GetMapping(value = "/queryCargoStorage/batchesAndWarehouseCode", produces = "application/json")
    @ApiOperation(value = "根据批次号集合、仓库编码查询货品库存", notes = "根据批次号集合、仓库编码查询货品库存")
    RestResponse<List<CargoStorageDto>> queryCargoStorageByBatchesAndWarehouseCode(@RequestParam(name = "batchList") List<String> batchList, @RequestParam(name = "warehouseCode") String warehouseCode);

    @PostMapping(value = "/logicPreempt", produces = "application/json")
    @ApiOperation(value = "逻辑仓预占", notes = "逻辑仓预占")
    RestResponse<Void> logicPreempt(@Validated @RequestBody PreemptParam param);

    @PostMapping(value = "/releaseLogicPreempt", produces = "application/json")
    @ApiOperation(value = "逻辑仓释放预占", notes = "逻辑仓释放预占")
    RestResponse<Void> releaseLogicPreempt(@Validated @RequestBody ReleasePreemptParam param);

    @PostMapping(value = "/refreshPreempt", produces = "application/json")
    @ApiOperation(value = "逻辑仓刷新预占", notes = "逻辑仓刷新预占")
    RestResponse<Void> refreshPreempt(@Validated @RequestBody PreemptParam param);

    @PostMapping(value = "/releaseParentAndPreemptChild", produces = "application/json")
    @ApiOperation(value = "释放主单预占，重新按子单预占", notes = "释放主单预占，重新按子单预占")
    RestResponse<Void> releaseParentAndPreemptChild(@Validated @RequestBody ReleaseParentAndPreemptChildParam param);

    @PostMapping(value = "/releaseChildAndPreemptParent", produces = "application/json")
    @ApiOperation(value = "释放子单预占，重新按主单预占", notes = "释放子单预占，重新按主单预占")
    RestResponse<Void> releaseChildAndPreemptParent(@Validated @RequestBody ReleaseChildAndPreemptParentParam param);

    @PostMapping(value = "/releaseChildAndPreemptChild", produces = "application/json")
    @ApiOperation(value = "释放子单预占，重新按子单预占", notes = "释放子单预占，重新按子单预占")
    RestResponse<Void> releaseChildAndPreemptChild(@Validated @RequestBody ReleaseChildAndPreemptChildParam param);
}
