package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 库存调整单明细服务接口
*
* @author author
* @since 2022-07-12
*/
@Api(tags = {"库存调整单明细服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IAdjustmentInventoryDetailQueryApi",
    name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}",
    path = "/v1/adjustmentInventoryDetail",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IAdjustmentInventoryDetailQueryApi {

    /**
    * 根据id查询库存调整单明细
    *
    * @param id 库存调整单明细id
    * @return   库存调整单明细数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存调整单明细", notes = "根据id查询库存调整单明细")
    RestResponse<AdjustmentInventoryDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 库存调整单明细分页数据
    *
    * @param filter   库存调整单明细查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 库存调整单明细分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "库存调整单明细分页数据", notes = "根据filter查询条件查询库存调整单明细数据，filter=AdjustmentInventoryDetailReqDto")
    RestResponse<PageInfo<AdjustmentInventoryDetailRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
