package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.adjustmentInventoryStatusCountRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 库存调整单服务接口
*
* @author author
* @since 2022-07-12
*/
@Api(tags = {"库存调整单服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IAdjustmentInventoryQueryApi",
    name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}",
    path = "/v1/adjustmentInventory",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IAdjustmentInventoryQueryApi {

    /**
     * 根据id查询库存调整单
     *
     * @param id 库存调整单id
     * @return 库存调整单数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存调整单", notes = "根据id查询库存调整单")
    RestResponse<AdjustmentInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据库存调整单号查询库存调整单详情
     *
     * @param adjustmentNo 库存调整单号
     * @return 库存调整单数据
     */
    @GetMapping("/queryByAdjustmentNo")
    @ApiOperation(value = "根据库存调整单号查询库存调整单详情", notes = "根据库存调整单号查询库存调整单详情")
    RestResponse<AdjustmentInventoryRespDto> queryByAdjustmentNo(@RequestParam("adjustmentNo") String adjustmentNo);

    /**
     * 库存调整单分页数据
     *
     * @param filter   库存调整单查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 库存调整单分页数据
     */
    @GetMapping("/page")
    @ApiOperation(tags ={"库存调整单分页数据"},value = "库存调整单分页数据", notes = "根据filter查询条件查询库存调整单数据，filter=AdjustmentInventoryReqDto")
    RestResponse<PageInfo<AdjustmentInventoryRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
    /**
     * 库存调整单状态数量统计
     *
     * @param filter   库存调整单查询条件
     * @return 库存调整单状态数量
     */
    @GetMapping("/adjustmentInventoryStatusCount")
    @ApiOperation(tags ={"库存调整单状态数量统计"},value = "库存调整单状态数量统计", notes = "根据filter查询条件查询库存调整单数据，filter=AdjustmentInventoryReqDto")
    RestResponse<adjustmentInventoryStatusCountRespDto> adjustmentInventoryStatusCount(@RequestParam("filter") String filter);

}
