package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 业务类型表服务接口
 *
 * @author wuyue
 * @since 2022-04-26
 */
@Api(tags = {"业务类型表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsBusinessTypeQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/business/type",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsBusinessTypeQueryApi {

    /**
     * 根据id查询业务类型表
     *
     * @param id 业务类型表id
     * @return 业务类型表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询业务类型表", notes = "根据id查询业务类型表")
    RestResponse<CsBusinessTypeRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据id查询业务类型表
     *
     * @param csBusinessTypeReqDto 业务类型表id
     * @return 业务类型表数据
     */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据列表查询业务类型表", notes = "根据id列表查询业务类型表")
    RestResponse<List<CsBusinessTypeRespDto>> queryByIds(@RequestBody CsBusinessTypeReqDto csBusinessTypeReqDto);

    /**
     * 业务类型表分页数据
     *
     * @param filter   业务类型表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 业务类型表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "业务类型表分页数据", notes = "根据filter查询条件查询业务类型表数据，filter=CsBusinessTypeReqDto")
    RestResponse<PageInfo<CsBusinessTypeRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据类型查询业务类型
     *
     * @param type 类型 other_out:其他出库 other_in:其他入库
     * @return 结果
     */
    @GetMapping("/queryByType/{type}")
    @ApiOperation(value = "下拉使用 类型 other_out:其他出库 other_in:其他入库 ", notes = "根据类型查询业务类型下拉使用 类型other_out:其他出库 other_in:其他入库")
    RestResponse<Map<Long, String>> queryByType(@PathVariable("type") String type);

    /**
     * 根据类型查询业务类型
     *
     * @param type 类型 other_out:其他出库 other_in:其他入库
     * @return 结果
     */
    @GetMapping("/queryListByType/{type}")
    @ApiOperation(value = "根据类型查询业务类型 类型 other_out:其他出库 other_in:其他入库", notes = "根据类型查询业务类型 类型 other_out:其他出库 other_in:其他入库")
    RestResponse<List<CsBusinessTypeRespDto>> queryListByType(@PathVariable("type") String type);
}
