package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 其他出入库单明细服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"其他出入库单明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsOtherStorageOrderDetailQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/other/storage/order/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsOtherStorageOrderDetailQueryApi {

    /**
     * 根据id查询其他出入库单明细
     *
     * @param id 其他出入库单明细id
     * @return 其他出入库单明细数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询其他出入库单明细", notes = "根据id查询其他出入库单明细")
    RestResponse<CsOtherStorageOrderDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 其他出入库单明细分页数据
     *
     * @param otherOrderNo 其他出入库单单号
     * @param pageNum      当前页
     * @param pageSize     页大小
     * @return 其他出入库单明细分页数据
     */
    @GetMapping("/page/{otherOrderNo}")
    @ApiOperation(value = "其他出入库单明细分页数据", notes = "其他出入库单明细分页数据")
    RestResponse<PageInfo<CsOtherStorageOrderDetailRespDto>> queryByPage(@PathVariable("otherOrderNo") String otherOrderNo,
                                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 其他出入库单明细分页数据
     *
     * @param otherOrderNo 其他出入库单单号
     * @return 其他出入库单明细分页数据
     */
    @GetMapping("/queryListByOtherOrderNo/{otherOrderNo}")
    @ApiOperation(value = "其他出入库单明细不分页数据", notes = "其他出入库单明细不分页数据")
    RestResponse<List<CsOtherStorageOrderDetailRespDto>> queryListByOtherOrderNo(@PathVariable("otherOrderNo") String otherOrderNo);

}
