package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBatchItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBatchItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRelevanceOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOtherStorageOrderQueryDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 其他出入库单服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"其他出入库单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsOtherStorageOrderQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/other/storage/order",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsOtherStorageOrderQueryApi {

    /**
     * 根据id查询其他出入库单
     *
     * @param id 其他出入库单id
     * @return 其他出入库单数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询其他出入库单", notes = "根据id查询其他出入库单")
    RestResponse<CsOtherStorageOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据编号查询其他出入库单
     *
     * @param otherStorageNo 编号
     * @return 其他出入库单数据
     */
    @GetMapping("/queryByOtherStorageNo/{otherStorageNo}")
    @ApiOperation(value = "根据编号查询其他出入库单", notes = "根据编号查询其他出入库单")
    RestResponse<CsOtherStorageOrderRespDto> queryByOtherStorageNo(@PathVariable("otherStorageNo") String otherStorageNo);

    /**
     * 根据其他出入库单号和长编码查询对应的批次详情商品信息
     *
     * @param csBatchItemQueryDto csBatchItemQueryDto
     * @return 批次详情商品信息
     */
    @PostMapping("/queryBatchItemByStorageOrderNo")
    @ApiOperation(value = "根据其他出入库单号和长编码查询对应的批次详情商品信息", notes = "根据其他出入库单号和长编码查询对应的批次详情商品信息")
    RestResponse<List<CsBatchItemRespDto>> queryBatchItemByStorageOrderNo(@RequestBody CsBatchItemQueryDto csBatchItemQueryDto);

    /**
     * 根据其他出入库单号查询关联单据
     *
     * @param storageOrderNo 其他出入库单号
     * @param type           类型
     * @return 集合
     */
    @GetMapping("/queryOtherStorageOrderRelevanceOrder/{storageOrderNo}/{type}")
    @ApiOperation(value = "根据其他出入库单号查询关联单据", notes = "根据其他出入库单号查询关联单据")
    RestResponse<List<CsOtherStorageOrderRelevanceOrderRespDto>> queryOtherStorageOrderRelevanceOrder(@PathVariable("storageOrderNo") String storageOrderNo,
                                                                                                      @PathVariable("type") String type);

    /**
     * 其他出入库单分页数据
     *
     * @param csOtherStorageOrderQueryDto 其他出入库单查询条件
     * @param pageNum                     当前页
     * @param pageSize                    页大小
     * @return 其他出入库单分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "其他出入库单分页数据", notes = "根据filter查询条件查询其他出入库单数据，filter=CsOtherStorageOrderReqDto")
    RestResponse<PageInfo<CsOtherStorageOrderRespDto>> queryByPage(@RequestBody CsOtherStorageOrderQueryDto csOtherStorageOrderQueryDto,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
