package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsStorageAuditRecordRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 单据审核记录表服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"单据审核记录表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsStorageAuditRecordQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/storage/audit/record",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsStorageAuditRecordQueryApi {

    /**
     * 根据id查询单据审核记录表
     *
     * @param id 单据审核记录表id
     * @return 单据审核记录表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询单据审核记录表", notes = "根据id查询单据审核记录表")
    RestResponse<CsStorageAuditRecordRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 单据审核记录表分页数据
     *
     * @param filter   单据审核记录表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 单据审核记录表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "单据审核记录表分页数据", notes = "根据filter查询条件查询单据审核记录表数据，filter=CsStorageAuditRecordReqDto")
    RestResponse<PageInfo<CsStorageAuditRecordRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据来源单号查询单据审核记录表
     *
     * @param orderSrcNo 来源单号
     * @return 审核记过列表
     */
    @GetMapping("/queryListByOrderSrcNo/{orderSrcNo}")
    @ApiOperation(value = "根据来源单号查询单据审核记录表", notes = "根据来源单号查询单据审核记录表")
    RestResponse<List<CsStorageAuditRecordRespDto>> queryListByOrderSrcNo(@PathVariable("orderSrcNo") String orderSrcNo);
}
