package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsStorageSnCodeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 单据串码表服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"单据串码表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsStorageSnCodeQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/storage/sn/code",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsStorageSnCodeQueryApi {

    /**
     * 根据id查询单据串码表
     *
     * @param id 单据串码表id
     * @return 单据串码表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询单据串码表", notes = "根据id查询单据串码表")
    RestResponse<CsStorageSnCodeRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 单据串码表分页数据
     *
     * @param filter   单据串码表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 单据串码表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "单据串码表分页数据", notes = "根据filter查询条件查询单据串码表数据，filter=CsStorageSnCodeReqDto")
    RestResponse<PageInfo<CsStorageSnCodeRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
