package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsTransferOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsTransferOrderDetailResponseDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 调拨单明细服务接口
 *
 * @author wuyue
 * @since 2022-05-17
 */
@Api(tags = {"调拨单明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsTransferOrderDetailQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/transfer/order/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsTransferOrderDetailQueryApi {

    /**
     * 根据id查询调拨单明细
     *
     * @param id 调拨单明细id
     * @return 调拨单明细数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询调拨单明细", notes = "根据id查询调拨单明细")
    RestResponse<CsTransferOrderDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 调拨单明细分页数据
     *
     * @param transferOrderNo 调拨单明细查询条件
     * @param pageNum         当前页
     * @param pageSize        页大小
     * @return 调拨单明细分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "调拨单明细分页数据", notes = "调拨单明细分页数据")
    RestResponse<PageInfo<CsTransferOrderDetailRespDto>> queryByPage(@RequestParam("transferOrderNo") String transferOrderNo,
                                                                     @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据调拨单号查询调拨单明细
     *
     * @param transferOrderNo 调拨单号
     * @return 调拨单明细数据
     */
    @GetMapping("/queryListByTransferOrderNo/{transferOrderNo}")
    @ApiOperation(value = "根据调拨单号查询调拨单明细", notes = "根据调拨单号查询调拨单明细")
    RestResponse<List<CsTransferOrderDetailRespDto>> queryListByTransferOrderNo(@PathVariable("transferOrderNo") String transferOrderNo);

    /**
     * 根据调拨单号查询调拨批次单明细分页
     *
     * @param transferOrderNo 调拨单明细查询条件
     * @param pageNum         当前页
     * @param pageSize        页大小
     * @return 调拨单明细分页数据
     */
    @GetMapping("/queryDetailListByTransferOrderNo")
    @ApiOperation(value = "根据调拨单号查询调拨批次单明细分页", notes = "根据调拨单号查询调拨批次单明细分页")
    RestResponse<PageInfo<CsTransferOrderDetailResponseDto>> queryDetailListByTransferOrderNo(@RequestParam("transferOrderNo") String transferOrderNo,
                                                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
