package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TranferOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsTransferOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 业务类型表服务接口
 *
 * @author wuyue
 * @since 2022-05-17
 */
@Api(tags = {"调拨单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsTransferOrderQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/transfer/order",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsTransferOrderQueryApi {

    /**
     * 根据id查询业务类型表
     *
     * @param id 业务类型表id
     * @return 业务类型表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询调拨单表", notes = "根据id查询调拨单表")
    RestResponse<CsTransferOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 调拨单分页数据
     *
     * @param queryDto   调拨单查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 调拨单分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "调拨单分页数据", notes = "调拨单分页数据")
    RestResponse<PageInfo<CsTransferOrderRespDto>> queryByPage(@RequestBody CsTransferOrderQueryDto queryDto,
                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据调拨单号查询调拨单表
     *
     * @param transferOrderNo 调拨单号
     * @return 调拨单表数据
     */
    @GetMapping("/queryByTransferOrderNo/{transferOrderNo}")
    @ApiOperation(value = "根据调拨单号查询调拨单表", notes = "根据调拨单号查询调拨单表")
    RestResponse<CsTransferOrderRespDto> queryByTransferOrderNo(@PathVariable("transferOrderNo") String transferOrderNo);

    /**
     * 查询调拨单列表
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryTransferOrderList")
    @ApiOperation(value = "查询调拨单列表", notes = "查询调拨单列表")
    RestResponse<List<CsTransferOrderRespDto>> queryTransferOrderList(@RequestBody CsTransferOrderReqDto reqDto);

    /**
     * 查询调拨单订单状态数量
     * @param queryDto 请求参数
     * @return 各订单状态数量
     */
    @PostMapping("/tranferOrderCount")
    @ApiOperation(value = "查询调拨单订单状态数量", notes = "查询调拨单订单状态数量")
    RestResponse<List<TranferOrderCountRespDto>> tranferOrderCount(@RequestBody CsTransferOrderQueryDto queryDto);


    @PostMapping("/modifyTranferOrder")
    @ApiOperation(value = "修改调拨单状态", notes = "修改调拨单状态")
    RestResponse<Void> modifyTranferOrder(@RequestBody CsTransferOrderRespDto csTransferOrderRespDto);

}
