package com.dtyunxi.yundt.cube.center.inventory.api.inventory.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InternalTradeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 内部交易（多方调拨）服务接口
*
* @author jiejun
* @since 2022-07-30
*/
@Api(tags = {"内部交易（多方调拨）服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IInternalTradeQueryApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/internalTrade",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface IInternalTradeQueryApi {

    /**
     * 查询内部交易（多方调拨）列表
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryList")
    @ApiOperation(value = "查询内部交易（多方调拨）列表", notes = "查询内部交易（多方调拨）列表")
    RestResponse<List<InternalTradeRespDto>> queryList(@RequestBody InternalTradeReqDto reqDto);

//    /**
//    * 根据id查询内部交易（多方调拨）
//    *
//    * @param id 内部交易（多方调拨）id
//    * @return   内部交易（多方调拨）数据
//    */
//    @GetMapping("/{id}")
//    @ApiOperation(value = "根据id查询内部交易（多方调拨）", notes = "根据id查询内部交易（多方调拨）")
//    RestResponse<InternalTradeRespDto> queryById(@PathVariable("id") Long id);
//
//    /**
//    * 内部交易（多方调拨）分页数据
//    *
//    * @param filter   内部交易（多方调拨）查询条件
//    * @param pageNum  当前页
//    * @param pageSize 页大小
//    * @return 内部交易（多方调拨）分页数据
//    */
//    @GetMapping("/page")
//    @ApiOperation(value = "内部交易（多方调拨）分页数据", notes = "根据filter查询条件查询内部交易（多方调拨）数据，filter=InternalTradeReqDto")
//    RestResponse<PageInfo<InternalTradeRespDto>> queryByPage(@RequestParam("filter") String filter,
//                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
//                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
