package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.CargoStorageTotalRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
* 货品库存总表服务接口
*
* @author songjiang.zxj
* @since 2021-10-21
*/
@Api(tags = {"货品库存总表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICargoStorageTotalQueryApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/inventory/log",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICargoStorageTotalQueryApi {

    /**
    * 根据id查询货品库存总表
    *
    * @param id 货品库存总表id
    * @return   货品库存总表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询货品库存总表", notes = "根据id查询货品库存总表")
    RestResponse<CargoStorageTotalRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 货品库存总表分页数据
    *
    * @param filter   货品库存总表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 货品库存总表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "货品库存总表分页数据", notes = "根据filter查询条件查询货品库存总表数据，filter=CargoStorageTotalReqDto")
    RestResponse<PageInfo<CargoStorageTotalRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
