package com.dtyunxi.yundt.cube.center.inventory.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseAreaMappingRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 仓库区域映射规则服务接口
*
* @author 妙才
* @since 2022-12-24
*/
@Api(tags = {"仓库区域映射规则服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-IWarehouseAreaMappingQueryApi",
    name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}",
    path = "/v1/warehouseAreaMapping",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IWarehouseAreaMappingQueryApi {

    /**
    * 根据id查询仓库区域映射规则
    *
    * @param id 仓库区域映射规则id
    * @return   仓库区域映射规则数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓库区域映射规则", notes = "根据id查询仓库区域映射规则")
    RestResponse<WarehouseAreaMappingRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓库区域映射规则分页数据
    *
    * @param reqDto   仓库区域映射规则查询条件
    * @return 仓库区域映射规则分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "仓库区域映射规则分页数据", notes = "根据filter查询条件查询仓库区域映射规则数据，filter=WarehouseAreaMappingReqDto")
    RestResponse<PageInfo<WarehouseAreaMappingRespDto>> queryByPage(@RequestBody WarehouseAreaMappingReqDto reqDto);

}
