package com.dtyunxi.yundt.cube.center.inventory.constant;

/**
 * <p> 幂等校验前缀维护 </p>
 *
 * @author jinger
 * @since 1.0
 */
public interface IdempotentCheckKeyPre {
    /**
     * 发货通知单幂等校验前缀
     */
    public final String DeliveryNotice = "DeliveryNotice:";

    /**
     * 发货结果单幂等校验前缀
     */
    public final String DeliveryResult = "DeliveryResult:";

    /**
     * 收货通知单幂等校验前缀
     */
    public final String ReceiveNotice = "ReceiveNotice:";

    /**
     * 收货结果单幂等校验前缀
     */
    public final String ReceiveResult = "ReceiveResult:";

    /**
     * 入库通知单幂等校验前缀
     */
    public final String InNotice = "InNotice:";

    /**
     * 入库结果幂等校验前缀
     */
    public final String InResult = "InResult:";

    /**
     * 出库通知单幂等校验前缀
     */
    public final String OutNotice = "OutNotice:";

    /**
     * 出库结果幂等校验前缀
     */
    public final String OutResult = "OutResult:";

    /**
     * 发货批量审核通过幂等校验前缀
     */
    public final String BatchUpdateOrderStatusPass = "BatchUpdateOrderStatusPass:";

    /**
     * 发货批量审核不通过幂等校验前缀
     */
    public final String BatchUpdateOrderStatusNoPass = "BatchUpdateOrderStatusNoPass:";

    /**
     * 调整单批量审核幂等校验前缀
     */
    public final String BatchAdjustDocument = "BatchAdjustDocument:";

    /**
     * 库存预占幂等校验前缀
     */
    public final String PREEMPT_INVENTORY = "PREEMPT_INVENTORY:";

    /**
     * 库存释放等校验前缀
     */
    public final String RELEASE_INVENTORY = "RELEASE_INVENTORY:";

    /**
     * 发货库存扣减幂等校验前缀
     */
    public final String DEDUCTION_INVENTORY = "DEDUCTION_INVENTORY:";

    /**
     * 幂等后缀
     */
    public final String SUFFIX = "suffix";

    /**
     * 渠道库存预占幂等校验前缀
     */
    public final String PREEMPT_CHANNEL_INVENTORY = "PREEMPT_CHANNEL_INVENTORY:";

    /**
     * wms出库回传幂等校验前缀
     */
    public final String WMS_OUT_BACK = "WMS_OUT_BACK:";

    /**
     * wms入库回传幂等校验前缀
     */
    public final String WMS_IN_BACK = "WMS_IN_BACK:";

    /**
     * wms取消回传幂等校验前缀
     */
    public final String WMS_CANCEL_BACK = "WMS_CANCEL_BACK:";

    /**
     * 计划类逆向出库单据,审核接口
     */
    public final String OUT_PLANNED_AUDIT = "OUT_PLANNED_AUDIT:";

    /**
     * 计划类正向入库单据,审核接口
     */
    public final String IN_PLANNED_AUDIT = "IN_PLANNED_AUDIT:";

    /**
     * 调拨单新增，幂等校验前缀
     */
    public final String CREATE_TRANSFER = "CREATE_TRANSFER:";

    /**
     * 调拨单审核，幂等校验前缀
     */
    public final String AUDIT_TRANSFER = "AUDIT_TRANSFER:";

    /**
     * 其他出入库审核，幂等校验前缀
     */
    public final String AUDIT_OTHER_STORAGE = "AUDIT_OTHER_STORAGE:";

    /**
     * 批量锁库、解锁，幂等校验前缀
     */
    public final String UPDATE_LOCK_INVENTORY = "UPDATE_LOCK_INVENTORY:";

    /**
     * 生成出库通知单继续发货
     */
    public final String CONTINUE_DELIVERY = "CONTINUE_DELIVERY:";
}
