/**
 * @(#) InOrderCategory.java 1.0 2021/11/6/006
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述
 *
 * @author zimu
 * @date 2021/11/6/006
 * @since 1.0.0
 */
public enum InOrderCategory {
    C_101(101, "发货通知单"),
    C_102(102, "发货结果单"),
    C_201(201, "收货通知单"),
    C_202(202, "收货结果单"),
    C_301(301, "调整单"),
    ;

    InOrderCategory(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final int code;
    private final String desc;
    public static final Map<Integer, InOrderCategory> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));

    public static InOrderCategory forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
