package com.dtyunxi.yundt.cube.center.inventory.constant;

public enum InventoryBizDateBizTypeEnum {

    CS_IN_PLANNED_ORDER("cs_in_planned_order", "计划类正向入库单据"),
    CS_OUT_PLANNED_ORDER("cs_out_planned_order", "计划类逆向出库单据"),
    CS_BATCH_ADJUSTMENT_ORDER("cs_batch_adjustment_order", "批次调整单"),
    CS_ADJUSTMENT_ORDER("cs_adjustment_order", "调整单"),
    CS_INVENTORY_TAKE_STOCK_ORDER("cs_inventory_take_stock_order", "盘点单"),
    CS_OTHER_STORAGE_ORDER("cs_other_storage_order", "其他出入库单"),
    CS_TRANSFER_ORDER("cs_transfer_order", "调拨单"),
    CS_OUT_NOTICE_ORDER("cs_out_notice_order", "出入通知单"),
    CS_OUT_RESULT_ORDER("cs_out_result_order", "出入结果单"),
    CS_DELIVERY_NOTICE_ORDER("cs_delivery_notice_order", "收发通知单"),
    CS_DELIVERY_RESULT_ORDER("cs_delivery_result_order", "收发通知单"),



    ;

    private final String code;
    private final String name;

    InventoryBizDateBizTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static InventoryBizDateBizTypeEnum getStatusByCode(String code) {
        for (InventoryBizDateBizTypeEnum value : InventoryBizDateBizTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
