/**
 * @(#) AdjustActionEnum.java 1.0 2021/11/1/001
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *库存回传业务类型
 *
 */
public enum SendBackBizTypeEnum {

    E3("E3", "E3"),
    WMS("WMS", "WMS"),
    ;


    SendBackBizTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final String code;
    private final String desc;
    public static final Map<String, SendBackBizTypeEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));

    public static SendBackBizTypeEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
