/**
 * @(#) AdjustActionEnum.java 1.0 2021/11/1/001
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 仓库区域映射
 *
 * @author 妙才
 * @date 2021/11/1/001
 * @since 1.0.0
 */
public enum WarehouseAreaMappingTypeEnum {

    ALLOT_SALE("allot_sale", "销售调拨"),
    SALE_ORDER_OUT("sale_order_out", "发货"),
    ;


    WarehouseAreaMappingTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final String code;
    private final String desc;
    public static final Map<String, WarehouseAreaMappingTypeEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<String, WarehouseAreaMappingTypeEnum> NAME_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.desc, thisEnum -> thisEnum));

    public static WarehouseAreaMappingTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }
    public static WarehouseAreaMappingTypeEnum forName(String code) {
        return NAME_LOOKUP.get(code);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
