package com.dtyunxi.yundt.cube.center.inventory.dto.constant;

/**
 * @author wufan
 */

public enum OrderStatusEnum {
    /**
     * 待审核
     */
    DELIVERY_WAIT_AUDIT (1011,"待审核"),
    /**
     * 出库
     */
    DELIVERY_OUT(1012,"出库"),
    /**
     * 出库中
     */
    DELIVERY_OUT_ING(1013,"出库中"),
    /**
     * 已完成
     */
    DELIVERY_OUT_FINISH( 1014 ,"已完成"),
    /**
     * 已取消
     */
    DELIVERY_CANCEL( 1015 ,"已取消"),
    /**
     * 待审核
     */
    RECIPT_WAIT_AUDIT( 2011,"待审核" ),
    /**
     * 待配发
     */
    RECIPT_WAIT_DELIVER( 2012,"待配发" ),
    /**
     * 已配发
     */
    RECIPT_DELIVERED( 2013 ,"已配发"),
    /**
     * 待收货
     */
    RECIPT_WAIT_RECEIVE( 2014 ,"待收货"),
    /**
     * 已完成
     */
    RECIPT_FINISH( 2015 ,"已完成"),
    /**
     * 已取消
     */
    RECIPT_CANCEL( 2016 ,"已取消"),
    /**
     * 入库中
     */
    RECIPT_ING( 2017 ,"入库中"),
    /**
     * 待审核
     */
    ADJUST_WAIT_AUDIT( 3011,"待审核"),
    /**
     * 已调整
     */
    ADJUST_FINISH( 3012 ,"已调整"),
    /**
     * 审批拒绝
     */
    ADJUST_REFUSE( 3013 ,"审批拒绝");

    OrderStatusEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }
    private final Integer code;
    private final String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code){
        for (OrderStatusEnum value : OrderStatusEnum.values()) {
            if(value.code.equals(code)){
                return value.desc;
            }
        }
        return "";
    }
}
