package com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics;

/**
 * 盘点单类型
 *
 * @author ningyi
 * @version 1.0
 * @Date 2022/4/25 9:37
 */
public enum ResultStateEnum {
    SUCCESS(1, "成功"),
    FAIL(2, "失败"),
    ;

    ResultStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (ResultStateEnum value : ResultStateEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return "";
    }
}
