package com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics;

/**
 * 盘点单业务类型
 *
 * @author ningyi
 * @version 1.0
 * @Date 2022/4/25 9:37
 */
public enum TakeStockBizTypeEnum {
    DRAWING(1, "抽盘"),
    OVERALL(2, "全盘")
    ;

    TakeStockBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (TakeStockBizTypeEnum value : TakeStockBizTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return "";
    }
}
