package com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics;

/**
 * 盘点单状态
 *
 * @author ningyi
 * @version 1.0
 * @Date 2022/4/25 9:37
 */
public enum TakeStockOrderStatusEnum {
    WAIT_SUBMIT("wait_submit","待提交"),
    WAIT_AUDIT("wait_audit","待审核"),
    AUDIT_FAILED("audit_failed","审核不通过"),
    CANCEL("cancel","已取消"),
    COMPLETED("completed","已完成"),
    EXECUTION_FAILED("execution_failed","执行失败")
    ;
    TakeStockOrderStatusEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }
    private String code;
    private String desc;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code){
        for (TakeStockOrderStatusEnum value : TakeStockOrderStatusEnum.values()) {
            if(value.code.equals(code)){
                return value.desc;
            }
        }
        return "";
    }
}
