package com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics;

/**
 * 盘点单类型
 *
 * @author ningyi
 * @version 1.0
 * @Date 2022/4/25 9:37
 */
public enum TakeStockTypeEnum {
    SURPLUS(1, "盘盈"),
    DISH(2, "盘亏"),
    NOT_HANDLE(3, "不处理"),
    ;

    TakeStockTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (TakeStockTypeEnum value : TakeStockTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return "";
    }
}
