package com.dtyunxi.yundt.cube.center.inventory.dto.constant.cs.basics;

/**
 *  仓库类型
 *
 * @author ningyi
 * @version 1.0
 * @Date 2022/4/25 9:37
 */
public enum TakeStockWarehouseTypeEnum {
    LOGIC_WAREHOUSE(1, "逻辑仓"),
    PHYSICAL_WAREHOUSE(2, "物理仓")
    ;

    TakeStockWarehouseTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (TakeStockWarehouseTypeEnum value : TakeStockWarehouseTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return "";
    }
}
