package com.dtyunxi.yundt.cube.center.inventory.dto.external;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class AllotOrderDetailDto {

    @ApiModelProperty(name="skuCode",value = "商品长编码")
    private String skuCode;

    @ApiModelProperty(name="quantity",value = "商品数量")
    private BigDecimal quantity;

    @ApiModelProperty(name="batch",value = "批次信息")
    private String batch;

    @ApiModelProperty(name="outWarehouseCode",value = "调出仓库编码")
    private String outWarehouseCode;

    @ApiModelProperty(name="inWarehouseCode",value = "调入仓库编码")
    private String inWarehouseCode;

    @ApiModelProperty(name="volume",value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(name="specification",value = "规格")
    private String specification;

    @ApiModelProperty(name="price",value = "单价（含税）")
    private BigDecimal price;

    @ApiModelProperty(name="saleOrderDetailId",value = "销售单明细ID")
    private String saleOrderDetailId;

    @ApiModelProperty(name="purchaseOrderDetailId",value = "采购单明细ID")
    private String purchaseOrderDetailId;

    @ApiModelProperty(name="externalDetailId",value = "外部单明细ID")
    private String externalDetailId;

    @ApiModelProperty(name="salePrice",value = "供货单价（含税）")
    private BigDecimal salePrice;

    @ApiModelProperty(name="actuallyAmount",value = "明细实付总额（含税）")
    private BigDecimal actuallyAmount;

    @ApiModelProperty(name="payableAmount",value = "明细应付总额（含税）")
    private BigDecimal payableAmount;

    @ApiModelProperty(name="discountAmount",value = "明细使用总折扣额")
    private BigDecimal discountAmount;

    @ApiModelProperty(name="taxRate",value = "税率")
    private BigDecimal taxRate;
}
