package com.dtyunxi.yundt.cube.center.inventory.dto.external;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class AllotOrderDto {

    @ApiModelProperty(name="platformOrderNo",value = "平台单号（多方调拨单号）")
    private String platformOrderNo;

    @ApiModelProperty(name="platformOrderParentNo",value = "父级平台单号（多方调拨单号）")
    private String platformOrderParentNo;

    @ApiModelProperty(name="externalSaleOrderNo",value = "外部销售单号")
    private String externalSaleOrderNo;

    @ApiModelProperty(name="externalSaleOrderId",value = "外部销售单ID")
    private String externalSaleOrderId;

    @ApiModelProperty(name="externalPurchaseOrderNo",value = "外部采购单号")
    private String externalPurchaseOrderNo;

    @ApiModelProperty(name="externalPurchaseOrderId",value = "外部采购单ID")
    private String externalPurchaseOrderId;

    @ApiModelProperty(name="allotType",value = "internal_deal：内部交易;internal_deal_return：内部交易退（两方）；sale_return_internal_deal：销售退货转内部交易（三方）")
    private String allotType;

    @ApiModelProperty(name="supplierCode",value = "供应商编码")
    private String supplierCode;

    @ApiModelProperty(name="remark",value = "备注信息")
    private String remark;

    @ApiModelProperty(name="outInventoryOrgCode",value = "调出库存组织")
    private String outInventoryOrgCode;

    @ApiModelProperty(name="inInventoryOrgCode",value = "调入库存组织")
    private String inInventoryOrgCode;

    @ApiModelProperty(name="saleCustomerCode",value = "销售单客户编号")
    private String saleCustomerCode;

    @ApiModelProperty(name="saleOrganizationCode",value = "销售组织")
    private String saleOrganizationCode;

    @ApiModelProperty(name="itemTotalAmount",value = "商品金额总和")
    private BigDecimal itemTotalAmount;

    @ApiModelProperty(name="itemDetailList",value = "商品明细")
    private List<AllotOrderDetailDto> itemDetailList;

}
