package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 库存调整单明细ReqDto对象
 *
 * @author author
 * @since 2022-07-12
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AdjustmentInventoryDetailReqDto", description = "库存调整单明细Eo对象")
public class AdjustmentInventoryDetailReqDto extends RequestDto {
    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 单据编号
     */
    @ApiModelProperty(name = "adjustmentNo", value = "单据编号")
    private String adjustmentNo;
    /**
     * 库存调整单主表id
     */
    @ApiModelProperty(name = "adjustmentId", value = "库存调整单主表id")
    private Long adjustmentId;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 货品编码/商品sku
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码/商品sku")
    private String cargoCode;
    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
     * 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
     */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
     * 变更类型：increase增加，decrease减少
     */
    @ApiModelProperty(name = "changeType", value = "变更类型：increase增加，decrease减少")
    private String changeType;
    /**
     * 变更数量
     */
    @ApiModelProperty(name = "changeQuantity", value = "变更数量")
    private BigDecimal changeQuantity;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 批次号
     */
    @ApiModelProperty(name = "batch", value = "批次号")
    private String batch;

    /**
     * 生产日期
     **/
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    /**
     * 过期日期
     **/
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

}
