package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 盘点单ReqDto对象
 *
 * @author author
 * @since 2022-07-12
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AdjustmentInventoryReqDto", description = "盘点单Eo对象")
public class AdjustmentInventoryReqDto extends RequestDto {
    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 单据编号
     */
    @ApiModelProperty(name = "adjustmentNo", value = "单据编号")
    private String adjustmentNo;

    @ApiModelProperty(name="adjustmentNoList", value = "单据编号列表")
    private List<String> adjustmentNoList;

    /**
     * 单据状态：wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：已驳回
     */
    @ApiModelProperty(name = "adjustmentStatus", value = "单据状态：wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：已驳回")
    private String adjustmentStatus;
    /**
     * 仓库类型：logic逻辑仓，physics物理仓
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型：logic逻辑仓，physics物理仓")
    private String warehouseType;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 盘点单备注
     */
    @ApiModelProperty(name = "adjustmentRemark", value = "盘点单备注")
    private String adjustmentRemark;

    @ApiModelProperty(name = "detailReqDtoList", value = "盘点单的商品信息")
    private List<AdjustmentInventoryDetailReqDto> detailReqDtoList;

    @ApiModelProperty(name = "startTime", value = "搜索的开始时间")
    private Date startTime;

    @ApiModelProperty(name = "endTime", value = "搜索的结束时间")
    private Date endTime;
    /**
     * 调整单类型：check_stock-盘点单，in_transit_adjustment-在途库存调整单
     */
    @ApiModelProperty(name = "adjustmentType", value = "调整单类型：check_stock-盘点单，in_transit_adjustment-在途库存调整单")
    private String adjustmentType= CsPcpBusinessTypeEnum.CHECK_STOCK.getCode();

    /**
     * 业务类型 in_transit_adjustment_out-在途库存出库, in_transit_adjustment_in-在途库存入库
     */
    @ApiModelProperty(name = "businessType", value = "业务类型 in_transit_adjustment_out-在途库存出库, in_transit_adjustment_in-在途库存入库")
    private String businessType;

    /**
     * @see com.dtyunxi.yundt.cube.center.inventory.enums.AdjustSourceTypeEnum
     * 来源类型
     */
    @ApiModelProperty(name = "sourceType", value = "来源类型")
    private String sourceType;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;

    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;

    /**
     * 仓库分类：仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类：仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;

    /**
     * 是否自动审核通过
     */
    @ApiModelProperty(name = "autoAuditPass", value = "是否自动审核通过：ture 自动审核")
    private Boolean autoAuditPass = false;

    /**
     * 来源类型集合
     */
    @ApiModelProperty(name = "sourceTypeList", value = "来源类型集合（支持查询）")
    private List<String> sourceTypeList;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

}
