package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 单据解挂实体类
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsStorageCancelHangUpReqDto", description = "单据解挂实体类")
public class CsStorageCancelHangUpReqDto implements Serializable {

    /**
     * 来源单号
     */
    @NotBlank
    @ApiModelProperty(name = "orderSrcNo", value = "来源单号,入出入库单号",required = true)
    private String orderSrcNo;

    /**
     * 结果单号
     */
    @NotBlank
    @ApiModelProperty(name = "resultCode", value = "结果单号",required = true)
    private String resultCode;

    /**
     * remark
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getOrderSrcNo() {
        return orderSrcNo;
    }

    public void setOrderSrcNo(String orderSrcNo) {
        this.orderSrcNo = orderSrcNo;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
