package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 单据调整实体类
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsStorageItemAdjustReqDto", description = "单据调整实体类")
public class CsStorageItemAdjustReqDto implements Serializable {

    /**
     * 修改的商品明细id
     */
    @ApiModelProperty(name = "id", value = "修改的商品明细id")
    private Long id;
    /**
     * 其他出入库单据编号
     */
    @NotBlank
    @ApiModelProperty(name = "longCode", value = "其他出入库单据编号")
    private String longCode;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "artNo", value = "商品名称")
    private String cargoName;

    /**
     * 前置单号
     */
    @ApiModelProperty(name = "batch", value = "商品长编码")
    private String batch;

    /**
     * 数量
     */
    @NotNull
    @ApiModelProperty(name = "quantity", value = "数量")
    private BigDecimal quantity;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
}
