package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他出入库单回调对象
 *
 * @author wuyue
 * @since 2022-05-06
 */
@ApiModel(value = "CsOtherStorageOrderCallBackReqDto", description = "其他出入库单回调对象")
public class CsStorageOrderCallBackReqDto extends RequestDto {
    /**
     * 其他出入库单据编号
     */
    @ApiModelProperty(name = "documentNo", value = "其他出入库单据编号")
    private String documentNo;

    /**
     * wms单号
     */
    @ApiModelProperty(name = "wmsNo", value = "wms单号")
    private String wmsNo;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "warehouseCode", value = "业务类型")
    private String warehouseCode;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "物理发货仓编码")
    private String deliveryPhysicsWarehouseCode;
    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;

    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "shippingCode", value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 备注
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * createPerson
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;


    @ApiModelProperty(name = "detailList", value = "商品明细,不能为空")
    private List<CsCallBackItemReqDto> detailList = new ArrayList<>();

    public List<CsCallBackItemReqDto> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CsCallBackItemReqDto> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getDocumentNo() {
        return documentNo;
    }


    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getDeliveryPhysicsWarehouseCode() {
        return deliveryPhysicsWarehouseCode;
    }

    public void setDeliveryPhysicsWarehouseCode(String deliveryPhysicsWarehouseCode) {
        this.deliveryPhysicsWarehouseCode = deliveryPhysicsWarehouseCode;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }
}
