package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsBasicsOrderReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 库存单据发送mq实体类
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsStorageSendMqReqDto", description = "库存单据发送mq实体类")
public class CsStorageSendMqReqDto implements Serializable {
    /**
     * mq消息日志id(不用传)
     */
    @ApiModelProperty(name = "messageId", value = "不用传")
    private Long messageId;
    /**
     * 业务单号
     */
    @NotBlank
    @ApiModelProperty(name = "businessOrderNo", value = "业务单号", required = true)
    private String businessOrderNo;
    /**
     * 前置单据
     */
    @NotBlank
    @ApiModelProperty(name = "preDocumentNo", value = "前置单据", required = true)
    private String preDocumentNo;

    /**
     * 业务类型
     */
    @NotBlank
    @ApiModelProperty(name = "businessType", value = "业务类型", required = true)
    private String businessType;

    /**
     * 操作类型
     */
    @NotBlank
    @ApiModelProperty(name = "operateType", value = "操作类型", required = true)
    private String operateType;

    /**
     * 发送mq的类型 11 创建出入库货通知单  12 创建收发货结果单
     */
    @ApiModelProperty(name = "type", value = "发送mq的类型 11 创建出入库货通知单  12 创建收发货结果单", required = true)
    private Integer type;

    /**
     * 基础单据对象
     */
    @ApiModelProperty(name = "csBasicsOrderReqDto", value = "基础单据对象", required = true)
    private CsBasicsOrderReqDto csBasicsOrderReqDto;


    public CsBasicsOrderReqDto getCsBasicsOrderReqDto() {
        return csBasicsOrderReqDto;
    }

    public void setCsBasicsOrderReqDto(CsBasicsOrderReqDto csBasicsOrderReqDto) {
        this.csBasicsOrderReqDto = csBasicsOrderReqDto;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public Long getMessageId() {
        return messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public String getPreDocumentNo() {
        return preDocumentNo;
    }

    public void setPreDocumentNo(String preDocumentNo) {
        this.preDocumentNo = preDocumentNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
