package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.yundt.cube.center.data.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Eas调拨单明细对象
 *
 * @author wuyue
 * @since 2022-05-17
 */
@ApiModel(value = "EasTransferOrderDetailReqDto", description = "Eas调拨单明细对象")
public class EasTransferOrderDetailReqDto extends BaseDto implements Serializable {
    /**
     * 商品长编码
     */
    @NotBlank
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 数量
     */
    @NotNull
    @ApiModelProperty(name = "quantity", value = "数量")
    private BigDecimal quantity;
    /**
     * 体积
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    /**
     * 货品批次
     */
    @NotBlank
    @ApiModelProperty(name = "batch", value = "货品批次")
    private String batch;
    /**
     * 出库仓编码
     */
    @ApiModelProperty(name = "outWarehouseCode", value = "出库仓编码")
    private String outWarehouseCode;
    /**
     * 入库仓编码
     */
    @ApiModelProperty(name = "inWarehouseCode", value = "入库仓编码")
    private String inWarehouseCode;

    @ApiModelProperty(name = "expireTime", value = "生产日期")
    @DateTimeFormat
    private Date produceTime;
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    @DateTimeFormat
    private Date expireTime;

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getOutWarehouseCode() {
        return outWarehouseCode;
    }

    public void setOutWarehouseCode(String outWarehouseCode) {
        this.outWarehouseCode = outWarehouseCode;
    }

    public String getInWarehouseCode() {
        return inWarehouseCode;
    }

    public void setInWarehouseCode(String inWarehouseCode) {
        this.inWarehouseCode = inWarehouseCode;
    }
}
