package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.yundt.cube.center.data.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * EAS调拨单主信息
 *
 * @author wuyue
 * @since 2022-05-17
 */
@ApiModel(value = "EasTransferOrderReqDto", description = "EAS调拨单主信息")
public class EasTransferOrderReqDto extends BaseDto implements Serializable {
    /**
     * 平台单号
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号")
    private String platformOrderNo;
    /**
     * 外部采购单号
     */
    @ApiModelProperty(name = "externalPurchaseOrderNo", value = "外部采购单号")
    private String externalPurchaseOrderNo;
    /**
     * 外部销售单号
     */
    @ApiModelProperty(name = "externalSaleOrderNo", value = "外部销售单号")
    private String externalSaleOrderNo;

    @ApiModelProperty(name = "parentOrderNo", value = "父级单号（拆单场景使用）")
    private String parentOrderNo;

    /**
     * 调拨单据类型
     */
    @NotBlank
    @ApiModelProperty(name = "allotType", value = "调拨单据类型 ")
    private String allotType;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 调出逻辑仓库编码
     */
    @ApiModelProperty(name = "outWarehouseCode", value = "调出仓库编码")
    private String outWarehouseCode;
    /**
     * 调入逻辑仓库编码
     */
    @ApiModelProperty(name = "inWarehouseCode", value = "调入逻辑仓库编码")
    private String inWarehouseCode;
    /**
     * 货主
     */
    @ApiModelProperty(name = "fOwner", value = "货主")
    private String fOwner;
    /**
     * 库存组织
     */
    @ApiModelProperty(name = "fStorageOrg", value = "库存组织")
    private String fStorageOrg;
    /**
     * 财务组织编码
     */
    @ApiModelProperty(name = "fCompanyOrg", value = "财务组织编码")
    private String fCompanyOrg;
    /**
     * 订单日期
     */
    @ApiModelProperty(name = "fBizDate", value = "订单日期")
    private String fBizDate;
    /**
     * 物理仓
     */
    @ApiModelProperty(name = "fPhyWarehs", value = "物理仓")
    private String fPhyWarehs;
    /**
     * 备注
     */
    @ApiModelProperty(name = "fDescription", value = "备注")
    private String fDescription;


    @ApiModelProperty(name = "itemDetailList", value = "明细信息")
    private List<EasTransferOrderDetailReqDto> itemDetailList = new ArrayList<>();

    @ApiModelProperty(name = "businessOrderNo", value = "businessOrderNo")
    private String businessOrderNo;

    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;

    @ApiModelProperty(name = "subType", value = "调拨单据类型(外部无需处理，内部逻辑使用) ")
    private String subType;

    @ApiModelProperty(name = "warehouseCode", value = "查询明细的仓库编码，仅记录的就为空(外部无需处理，内部逻辑使用)")
    private String warehouseCode;


    /**
     * 计划调出时间
     */
    @ApiModelProperty(name = "planOutTime", value = "计划调出时间")
    private Date planOutTime;

    /**
     * 计划调入时间
     */
    @ApiModelProperty(name = "planInTime", value = "计划调入时间")
    private Date planInTime;

    @ApiModelProperty(name = "autoAudit", value = "自动审核：true-自动审核，false-不审核；默认审核")
    private Boolean autoAudit=true;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Boolean getAutoAudit() {
        return autoAudit;
    }

    public void setAutoAudit(Boolean autoAudit) {
        this.autoAudit = autoAudit;
    }

    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    public Date getPlanOutTime() {
        return planOutTime;
    }

    public void setPlanOutTime(Date planOutTime) {
        this.planOutTime = planOutTime;
    }

    public Date getPlanInTime() {
        return planInTime;
    }

    public void setPlanInTime(Date planInTime) {
        this.planInTime = planInTime;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }


    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public String getfOwner() {
        return fOwner;
    }

    public void setfOwner(String fOwner) {
        this.fOwner = fOwner;
    }

    public String getfStorageOrg() {
        return fStorageOrg;
    }

    public void setfStorageOrg(String fStorageOrg) {
        this.fStorageOrg = fStorageOrg;
    }

    public String getfCompanyOrg() {
        return fCompanyOrg;
    }

    public void setfCompanyOrg(String fCompanyOrg) {
        this.fCompanyOrg = fCompanyOrg;
    }

    public String getfBizDate() {
        return fBizDate;
    }

    public void setfBizDate(String fBizDate) {
        this.fBizDate = fBizDate;
    }

    public String getfPhyWarehs() {
        return fPhyWarehs;
    }

    public void setfPhyWarehs(String fPhyWarehs) {
        this.fPhyWarehs = fPhyWarehs;
    }

    public String getfDescription() {
        return fDescription;
    }

    public void setfDescription(String fDescription) {
        this.fDescription = fDescription;
    }

    public String getOutWarehouseCode() {
        return outWarehouseCode;
    }

    public void setOutWarehouseCode(String outWarehouseCode) {
        this.outWarehouseCode = outWarehouseCode;
    }

    public String getInWarehouseCode() {
        return inWarehouseCode;
    }

    public void setInWarehouseCode(String inWarehouseCode) {
        this.inWarehouseCode = inWarehouseCode;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getExternalPurchaseOrderNo() {
        return externalPurchaseOrderNo;
    }

    public void setExternalPurchaseOrderNo(String externalPurchaseOrderNo) {
        this.externalPurchaseOrderNo = externalPurchaseOrderNo;
    }

    public String getExternalSaleOrderNo() {
        return externalSaleOrderNo;
    }

    public void setExternalSaleOrderNo(String externalSaleOrderNo) {
        this.externalSaleOrderNo = externalSaleOrderNo;
    }

    public String getAllotType() {
        return allotType;
    }

    public void setAllotType(String allotType) {
        this.allotType = allotType;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<EasTransferOrderDetailReqDto> getItemDetailList() {
        return itemDetailList;
    }

    public void setItemDetailList(List<EasTransferOrderDetailReqDto> itemDetailList) {
        this.itemDetailList = itemDetailList;
    }
}
