package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * MQ报文（发货/收货通知单）Eo对象
 *
 * @author 杰俊
 * @since 2021-09-28
 */
@ApiModel(value = "MqMessageReqDto", description = "MQ报文（发货/收货通知单）Eo对象")
public class MqMessageReqDto extends RequestDto {
    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
     * 报文类型 1：发货通知单  2：退货通知单
     */
    @ApiModelProperty(name = "type", value = "报文类型 1：发货通知单  2：退货通知单 ,11 出入库通知单 , 12 收发货结果单")
    private Integer type;
    /**
     * 单号
     */
    @ApiModelProperty(name = "no", value = "单号 (前置单号如:创建出入库通知单就传发货通知单号, 创建发货结果单就传出入库结果单号)")
    private String no;
    /**
     * 报文JSON
     */
    @ApiModelProperty(name = "message", value = "报文JSON")
    private String message;
    /**
     * 0：未获取  1：已获取  2: 消费mq成功单创建单据报错(备注信息有值) 3: 消费mq成功创建单据成功
     */
    @ApiModelProperty(name = "status", value = "状态 0：未获取  1：已获取  2: 消费mq成功单创建单据报错(备注信息有值) 3: 消费mq成功创建单据成功 (不传默认0)")
    private Integer status;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getNo() {
        return no;
    }

    public void setNo(String no) {
        this.no = no;
    }
}
