package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author shuidi
 */
@ApiModel(value = "tcbjInventoryLogReqDto", description = "查询Dto")
@Data
public class TcbjInventoryLogReqDto extends BasePageDto {
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    /**
     * 商品货号
     */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 库存类型
     */
    @ApiModelProperty(name = "type", value = "库存类型")
    private String type;
    /**
     * 业务单据类型 销售、调拨、退货
     */
    @ApiModelProperty(name = "orderType", value = "业务单据类型")//new
    private Double orderType;
    /**
     * 前置单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "前置单据号")
    private String relevanceNo;
    /**
     * 变动时间
     */
    @ApiModelProperty(name = "updateTimeStart", value = "变动时间Start")
    private String updateTimeStart;
    /**
     * 变动时间
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "变动时间End")
    private String updateTimeEnd;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "orgId", value = "组织ID")
    private Long orgId;
}