package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
* 库存调整单的审核信息Eo对象
*
* @author author
* @since 2022-07-12
*/
@ApiModel(value = "AdjustmentInventoryAuditRespDto", description = "库存调整单的审核信息Eo对象")
public class AdjustmentInventoryAuditRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  单据编号
    */
    @ApiModelProperty(name = "adjustmentNo", value = "单据编号")
    private String adjustmentNo;
    /**
    *  审核结果：pass审核通过、failed审核不通过
    */
    @ApiModelProperty(name = "auditStatus", value = "审核结果：pass审核通过、failed审核不通过")
    private String auditStatus;
    /**
    *  审核备注
    */
    @ApiModelProperty(name = "auditRemark", value = "审核备注")
    private String auditRemark;

    @ApiModelProperty(name = "auditIds", value = "库存调整单的ID集合")
    private List<Long> auditIds;

    @ApiModelProperty(name = "inOutOrderNo", value = "是否生成出入库通知单结果单、处理物理仓，默认生成、处理")
    private Boolean inOutOrder=true;

    public Boolean getInOutOrder() {
        return inOutOrder;
    }

    public void setInOutOrder(Boolean inOutOrder) {
        this.inOutOrder = inOutOrder;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setAdjustmentNo(String adjustmentNo){
    this.adjustmentNo = adjustmentNo;
    }
    public String getAdjustmentNo(){
    return this.adjustmentNo;
    }
    public void setAuditStatus(String auditStatus){
    this.auditStatus = auditStatus;
    }
    public String getAuditStatus(){
    return this.auditStatus;
    }
    public void setAuditRemark(String auditRemark){
    this.auditRemark = auditRemark;
    }
    public String getAuditRemark(){
    return this.auditRemark;
    }

    public List<Long> getAuditIds() {
        return auditIds;
    }

    public void setAuditIds(List<Long> auditIds) {
        this.auditIds = auditIds;
    }
}
