package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsBasisOrderRelOrderInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 库存调整单Eo对象
*
* @author author
* @since 2022-07-12
*/
@ApiModel(value = "AdjustmentInventoryRespDto", description = "库存调整单Eo对象")
@Data
public class AdjustmentInventoryRespDto extends BaseRespDto{
    /**
    *  单据编号
    */
    @ApiModelProperty(name = "adjustmentNo", value = "单据编号")
    private String adjustmentNo;
    /**
    *  单据状态：wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：已驳回
    */
    @ApiModelProperty(name = "adjustmentStatus", value = "单据状态：wait_audit：待审核、completed：已完成、cancel：已取消、audit_failed：已驳回")
    private String adjustmentStatus;
    /**
    *  仓库类型：logic逻辑仓，physics物理仓
    */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型：logic逻辑仓，physics物理仓")
    private String warehouseType;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  调整单备注
    */
    @ApiModelProperty(name = "adjustmentRemark", value = "调整单备注")
    private String adjustmentRemark;

    /**
     * 调整单类型：check_stock-盘点单，in_transit_adjustment-在途库存调整单
     */
    @ApiModelProperty(name = "adjustmentType", value = "调整单类型：check_stock-盘点单，in_transit_adjustment-在途库存调整单")
    private String adjustmentType;

    /**
     * 业务类型 in_transit_adjustment_out-在途库存出库, in_transit_adjustment_in-在途库存入库
     */
    @ApiModelProperty(name = "businessType", value = "业务类型 in_transit_adjustment_out-在途库存出库, in_transit_adjustment_in-在途库存入库")
    private String businessType;

    /**
     * 来源类型
     */
    @ApiModelProperty(name = "sourceType", value = "来源类型")
    private String sourceType;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;

    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;


    /**
     * 仓库分类：仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类：仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;

    @ApiModelProperty(name = "detailRespDtoList", value = "调整单的商品信息")
    private List<AdjustmentInventoryDetailRespDto> detailRespDtoList;

    @Deprecated
    @ApiModelProperty(name = "deliveryNoticeOrderRespDtoList", value = "收货/发货通知单")
    private List<CsDeliveryNoticeOrderRespDto> deliveryNoticeOrderRespDtoList;

    @Deprecated
    @ApiModelProperty(name = "outNoticeOrderRespDtoList", value = "出库/入库通知单")
    private List<CsOutNoticeOrderRespDto> outNoticeOrderRespDtoList;

    /**
     * 关联单据信息
     */
    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList;

    /**
     * 审核记录
     */
    @ApiModelProperty(name = "auditList", value = "审核记录")
    private List<AdjustmentInventoryAuditRespDto> auditList;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;


    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓名称")
    private String outLogicWarehouseName;

    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
}
