package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 其他出入库单明细Eo对象
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsOtherStorageOrderDetailRespDto", description = "其他出入库单明细Eo对象")
public class CsOtherStorageOrderDetailRespDto extends BaseRespDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 其他出入库单号
     */
    @ApiModelProperty(name = "otherOrderNo", value = "其他出入库单号")
    private String otherOrderNo;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "cargoId", value = "商品id")
    private Long cargoId;

    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "商品编码")
    private String cargoCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
     * 数量
     */
    @ApiModelProperty(name = "quantity", value = "数量")
    private BigDecimal quantity;
    /**
     * 数量
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
     * 数量
     */
    @ApiModelProperty(name = "specification", value = "规格")
    private String specification;

    /**
     * 已出/入库数量
     */
    @ApiModelProperty(name = "finishQuantity", value = "已出/入库数量")
    private BigDecimal finishQuantity;

    /**
     * 商品货号
     */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;

    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public BigDecimal getFinishQuantity() {
        return finishQuantity;
    }

    public void setFinishQuantity(BigDecimal finishQuantity) {
        this.finishQuantity = finishQuantity;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setOtherOrderNo(String otherOrderNo) {
        this.otherOrderNo = otherOrderNo;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getOtherOrderNo() {
        return this.otherOrderNo;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }
}
