package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 其他出入库单Eo对象
 *
 * @author wuyue
 * @since 2022-04-25
 */
@ApiModel(value = "CsOtherStorageOrderRespDto", description = "其他出入库单Eo对象")
public class CsOtherStorageOrderRespDto extends BaseRespDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 其他出入库单据编号
     */
    @ApiModelProperty(name = "storageOrderNo", value = "其他出入库单据编号")
    private String storageOrderNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    /**
     * 1:PCP 2:CSP
     */
    @ApiModelProperty(name = "orderSrc", value = "PCP,CSP")
    private Integer orderSrc;
    /**
     * 其他单据类型 other_out:其他出库 other_in:其他入库
     */
    @ApiModelProperty(name = "type", value = "其他单据类型 other_out:其他出库 other_in:其他入库")
    private String type;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private Long businessType;
    /**
     * 业务类型名称
     */
    @ApiModelProperty(name = "businessTypeName", value = "业务类型名称")
    private String businessTypeName;
    /**
     * 库存组织
     */
    @ApiModelProperty(name = "organization", value = "库存组织")
    private String organization;
    /**
     * 库存组织id
     */
    @ApiModelProperty(name = "organizationId", value = "库存组织id")
    private Long organizationId;
    /**
     * 仓库id
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库id")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 单据状态
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
     * 收货人
     */
    @ApiModelProperty(name = "consignee", value = "收货人")
    private String consignee;
    /**
     * 联系电话
     */
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;
    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
     * 总体积
     */
    @ApiModelProperty(name = "totalVolume", value = "总体积")
    private BigDecimal totalVolume;
    /**
     * 省id
     */
    @ApiModelProperty(name = "provinceCode", value = "省code")
    private String provinceCode;
    /**
     * 省
     */
    @ApiModelProperty(name = "provinceName", value = "省")
    private String provinceName;
    /**
     * 市id
     */
    @ApiModelProperty(name = "cityCode", value = "市code")
    private String cityCode;
    /**
     * 市
     */
    @ApiModelProperty(name = "cityName", value = "市")
    private String cityName;
    /**
     * 区id
     */
    @ApiModelProperty(name = "areaCode", value = "区code")
    private String areaCode;
    /**
     * 区
     */
    @ApiModelProperty(name = "areaName", value = "区")
    private String areaName;
    /**
     * 详细地址
     */
    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;
    /**
     * 摘要
     */
    @ApiModelProperty(name = "message", value = "摘要")
    private String message;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;


    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;

    @ApiModelProperty(name = "costCenterCode", value = "成本中心")
    private String costCenterCode;
    @ApiModelProperty(name = "isSendEas", value = "是否同步eas:1.是，0.否")
    private Integer isSendEas;

    /**
     * 原单是否不带批次：1.是，0或空.否
     */
    @ApiModelProperty(name = "noBatch", value = "原单是否不带批次：1.是，0或空.否")
    private Integer noBatch;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    @ApiModelProperty(name = "stringCodeResult", value = "串码验证结果 0-未读取;1-读码异常;2-读码成功")
    private Integer stringCodeResult;

    @ApiModelProperty(name = "stringCodeTime", value = "串码更新时间")
    private Date stringCodeTime;

    public Integer getStringCodeResult() {
        return stringCodeResult;
    }

    public void setStringCodeResult(Integer stringCodeResult) {
        this.stringCodeResult = stringCodeResult;
    }

    public Date getStringCodeTime() {
        return stringCodeTime;
    }

    public void setStringCodeTime(Date stringCodeTime) {
        this.stringCodeTime = stringCodeTime;
    }

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Integer getNoBatch() {
        return noBatch;
    }

    public void setNoBatch(Integer noBatch) {
        this.noBatch = noBatch;
    }

    public Integer getIsSendEas() {
        return isSendEas;
    }

    public void setIsSendEas(Integer isSendEas) {
        this.isSendEas = isSendEas;
    }

    public String getCostCenterCode() {
        return costCenterCode;
    }

    public void setCostCenterCode(String costCenterCode) {
        this.costCenterCode = costCenterCode;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public void setStorageOrderNo(String storageOrderNo) {
        this.storageOrderNo = storageOrderNo;
    }

    public String getStorageOrderNo() {
        return this.storageOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getPreOrderNo() {
        return this.preOrderNo;
    }

    public void setOrderSrc(Integer orderSrc) {
        this.orderSrc = orderSrc;
    }

    public Integer getOrderSrc() {
        return this.orderSrc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }

    public Long getBusinessType() {
        return this.businessType;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getOrganizationId() {
        return this.organizationId;
    }


    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseCode() {
        return this.warehouseCode;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getConsignee() {
        return this.consignee;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return this.phone;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public void setTotalVolume(BigDecimal totalVolume) {
        this.totalVolume = totalVolume;
    }

    public BigDecimal getTotalVolume() {
        return this.totalVolume;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }
}
