package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 调拨单
 *
 * @author wuyue
 * @since 2022-05-31
 */
@ApiModel(value = "TransferOrderDetailRespDto", description = "调拨单明细查询对象")
public class CsTransferOrderDetailResponseDto extends CsTransferOrderDetailRespDto {

    /**
     * 已出库数量
     */
    @ApiModelProperty(name = "doneDeliveryQuantity", value = "已出库数量")
    private BigDecimal doneDeliveryQuantity;

    /**
     * 已入库数量
     */
    @ApiModelProperty(name = "doneReceiveQuantity", value = "已入库数量")
    private BigDecimal doneReceiveQuantity;

    /**
     * 批次信息
     */
    @ApiModelProperty(name = "batchList", value = "批次信息")
    private List<TransferOrderBatchDetailRespDto> batchList = new ArrayList<>();

    public BigDecimal getDoneDeliveryQuantity() {
        return doneDeliveryQuantity;
    }

    public void setDoneDeliveryQuantity(BigDecimal doneDeliveryQuantity) {
        this.doneDeliveryQuantity = doneDeliveryQuantity;
    }

    public BigDecimal getDoneReceiveQuantity() {
        return doneReceiveQuantity;
    }

    public void setDoneReceiveQuantity(BigDecimal doneReceiveQuantity) {
        this.doneReceiveQuantity = doneReceiveQuantity;
    }

    public List<TransferOrderBatchDetailRespDto> getBatchList() {
        return batchList;
    }

    public void setBatchList(List<TransferOrderBatchDetailRespDto> batchList) {
        this.batchList = batchList;
    }
}
