package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 业务类型表Eo对象
 *
 * @author wuyue
 * @since 2022-05-17
 */
@ApiModel(value = "CsTransferOrderRespDto", description = "业务类型表Eo对象")
@Data
public class CsTransferOrderRespDto extends BaseRespDto {
    /**
     * 调拨单号
     */
    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号 ")
    private String preOrderNo;
    /**
     * 父级单号（拆单场景使用）
     */
    @ApiModelProperty(name = "parentOrderNo", value = "父级单号")
    private String parentOrderNo;

    @ApiModelProperty(name = "externalSaleOrderNo", value = "外部销售单号 ")
    private String externalSaleOrderNo;
    @ApiModelProperty(name = "externalPurchaseOrderNo", value = "外部采购单号 ")
    private String externalPurchaseOrderNo;
    /**
     * PCP,EAS等
     */
    @ApiModelProperty(name = "orderSrc", value = "PCP,EAS等")
    private String orderSrc;
    /**
     * 单据状态
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
     * 调出逻辑仓编码
     */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "调出逻辑仓编码")
    private String outLogicWarehouseCode;
    /**
     * 调出逻辑仓名称
     */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓名称")
    private String outLogicWarehouseName;
    /**
     * 调入逻辑仓编码
     */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "调入逻辑仓编码")
    private String inLogicWarehouseCode;
    /**
     * 调入逻辑仓名称
     */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓名称")
    private String inLogicWarehouseName;
    /**
     * 调出物理仓编码
     */
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "调出物理仓编码")
    private String outPhysicsWarehouseCode;
    /**
     * 调出物理仓名称
     */
    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "调出物理仓名称")
    private String outPhysicsWarehouseName;
    /**
     * 调出物理仓是否物流仓
     */
    @ApiModelProperty(name = "outPhysicsWarehouseIsLogistics", value = "调出物理仓是否物流仓")
    private Integer outPhysicsWarehouseIsLogistics;
    /**
     * 调入物理仓编码
     */
    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "调入物理仓编码")
    private String inPhysicsWarehouseCode;
    /**
     * 调入物理仓名称
     */
    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "调入物理仓名称")
    private String inPhysicsWarehouseName;
    /**
     * 调出库存组织
     */
    @ApiModelProperty(name = "outOrganization", value = "调出库存组织")
    private String outOrganization;
    /**
     * 调出库存组织id
     */
    @ApiModelProperty(name = "outOrganizationId", value = "调出库存组织id")
    private Long outOrganizationId;
    /**
     * 调入库存组织
     */
    @ApiModelProperty(name = "inOrganization", value = "调入库存组织")
    private String inOrganization;
    /**
     * 调入库存组织id
     */
    @ApiModelProperty(name = "inOrganizationId", value = "调入库存组织id")
    private Long inOrganizationId;
    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
     * 总重量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总重量")
    private BigDecimal totalWeight;
    /**
     * 总体积
     */
    @ApiModelProperty(name = "totalQuantity", value = "总体积")
    private BigDecimal totalVolume;
    /**
     * 总箱数
     */
    @ApiModelProperty(name = "totalQuantity", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     */
    @ApiModelProperty(name = "totalQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 调拨单类型
     */
    @ApiModelProperty(name = "type", value = "调拨单类型")
    private String type;

    /**
     * 已出库数量
     */
    @ApiModelProperty(name = "doneOutQuantity", value = "已出库数量")
    private BigDecimal doneOutQuantity;

    /**
     * 已入库数量
     */
    @ApiModelProperty(name = "doneInQuantity", value = "已入库数量")
    private BigDecimal doneInQuantity;

    @ApiModelProperty(name = "sourceSystem", value = "来源系统")
    private String sourceSystem;

    @ApiModelProperty(name = "subType", value = "调拨单子类型")
    private String subType;
    /**
     * 计划调出时间
     */
    @ApiModelProperty(name = "planOutTime", value = "计划调出时间")
    private Date planOutTime;

    /**
     * 计划调入时间
     */
    @ApiModelProperty(name = "planInTime", value = "计划调入时间")
    private Date planInTime;

    /**
     * 原单是否不带批次：1.是，0或空.否
     */
    @ApiModelProperty(name = "noBatch", value = "原单是否不带批次：1.是，0或空.否")
    private Integer noBatch;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    @ApiModelProperty(name = "saleOrderNo", value = "销售单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "province", value = "省")
    private String province;

    @ApiModelProperty(name = "provinceCode", value = "省编码")
    private String provinceCode;

    @ApiModelProperty(name = "city", value = "市")
    private String city;

    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;

    @ApiModelProperty(name = "area", value = "区")
    private String area;

    @ApiModelProperty(name = "areaCode", value = "区编码")
    private String areaCode;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;

    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;

    @ApiModelProperty(name = "contactPhone", value = "联系方式")
    private String contactPhone;

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getSaleOrderNo() {
        return saleOrderNo;
    }

    public void setSaleOrderNo(String saleOrderNo) {
        this.saleOrderNo = saleOrderNo;
    }

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Integer getNoBatch() {
        return noBatch;
    }

    public void setNoBatch(Integer noBatch) {
        this.noBatch = noBatch;
    }

    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    public Date getPlanOutTime() {
        return planOutTime;
    }

    public String getExternalSaleOrderNo() {
        return externalSaleOrderNo;
    }

    public void setExternalSaleOrderNo(String externalSaleOrderNo) {
        this.externalSaleOrderNo = externalSaleOrderNo;
    }

    public String getExternalPurchaseOrderNo() {
        return externalPurchaseOrderNo;
    }

    public void setExternalPurchaseOrderNo(String externalPurchaseOrderNo) {
        this.externalPurchaseOrderNo = externalPurchaseOrderNo;
    }

    public void setPlanOutTime(Date planOutTime) {
        this.planOutTime = planOutTime;
    }

    public Date getPlanInTime() {
        return planInTime;
    }

    public void setPlanInTime(Date planInTime) {
        this.planInTime = planInTime;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public BigDecimal getDoneOutQuantity() {
        return doneOutQuantity;
    }

    public void setDoneOutQuantity(BigDecimal doneOutQuantity) {
        this.doneOutQuantity = doneOutQuantity;
    }

    public BigDecimal getDoneInQuantity() {
        return doneInQuantity;
    }

    public void setDoneInQuantity(BigDecimal doneInQuantity) {
        this.doneInQuantity = doneInQuantity;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTransferOrderNo(String transferOrderNo) {
        this.transferOrderNo = transferOrderNo;
    }

    public String getTransferOrderNo() {
        return this.transferOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getPreOrderNo() {
        return this.preOrderNo;
    }

    public void setOrderSrc(String orderSrc) {
        this.orderSrc = orderSrc;
    }

    public String getOrderSrc() {
        return this.orderSrc;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setOutLogicWarehouseCode(String outLogicWarehouseCode) {
        this.outLogicWarehouseCode = outLogicWarehouseCode;
    }

    public String getOutLogicWarehouseCode() {
        return this.outLogicWarehouseCode;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public String getOutLogicWarehouseName() {
        return this.outLogicWarehouseName;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseCode() {
        return this.inLogicWarehouseCode;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public String getInLogicWarehouseName() {
        return this.inLogicWarehouseName;
    }

    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode) {
        this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }

    public String getOutPhysicsWarehouseCode() {
        return this.outPhysicsWarehouseCode;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }

    public String getOutPhysicsWarehouseName() {
        return this.outPhysicsWarehouseName;
    }

    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode) {
        this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }

    public String getInPhysicsWarehouseCode() {
        return this.inPhysicsWarehouseCode;
    }

    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName) {
        this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }

    public String getInPhysicsWarehouseName() {
        return this.inPhysicsWarehouseName;
    }

    public void setOutOrganization(String outOrganization) {
        this.outOrganization = outOrganization;
    }

    public String getOutOrganization() {
        return this.outOrganization;
    }

    public void setOutOrganizationId(Long outOrganizationId) {
        this.outOrganizationId = outOrganizationId;
    }

    public Long getOutOrganizationId() {
        return this.outOrganizationId;
    }

    public void setInOrganization(String inOrganization) {
        this.inOrganization = inOrganization;
    }

    public String getInOrganization() {
        return this.inOrganization;
    }

    public void setInOrganizationId(Long inOrganizationId) {
        this.inOrganizationId = inOrganizationId;
    }

    public Long getInOrganizationId() {
        return this.inOrganizationId;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getOutPhysicsWarehouseIsLogistics() {
        return outPhysicsWarehouseIsLogistics;
    }

    public void setOutPhysicsWarehouseIsLogistics(Integer outPhysicsWarehouseIsLogistics) {
        this.outPhysicsWarehouseIsLogistics = outPhysicsWarehouseIsLogistics;
    }
}
