package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

import javax.persistence.Column;

/**
* MQ报文（发货/收货通知单）Eo对象
*
* @author 杰俊
* @since 2021-09-28
*/
@ApiModel(value = "MqMessageRespDto", description = "MQ报文（发货/收货通知单）Eo对象")
public class MqMessageRespDto extends BaseRespDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  报文类型 1：发货通知单  2：退货通知单
    */
    @ApiModelProperty(name = "type", value = "报文类型 1：发货通知单  2：退货通知单")
    private Integer type;
    /**
     *  单号
     */
    @ApiModelProperty(name = "no", value = "单号")
    private String no;
    /**
    *  报文JSON
    */
    @ApiModelProperty(name = "message", value = "报文JSON")
    private String message;
    /**
    *  状态 0：未获取  1：已获取
    */
    @ApiModelProperty(name = "status", value = "状态 0：未获取  1：已获取")
    private Integer status;
    /**
     *  备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public void setType(Integer type){
    this.type = type;
    }
    public Integer getType(){
    return this.type;
    }
    public void setMessage(String message){
    this.message = message;
    }
    public String getMessage(){
    return this.message;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public String getNo() {
        return no;
    }
    public void setNo(String no) {
        this.no = no;
    }
}
