package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 调拨单
 *
 * @author wuyue
 * @since 2022-05-31
 */
@ApiModel(value = "TransferOrderBatchDetailRespDto", description = "调拨单批次明细查询对象")
public class TransferOrderBatchDetailRespDto {
    /**
     * 计划数量
     */
    @ApiModelProperty(name = "quantity", value = "计划数量")
    private BigDecimal quantity;

    /**
     * 批次号
     */
    @ApiModelProperty(name = "batch", value = "批次号")
    private String batch;

    /**
     * 已入库数量
     */
    @ApiModelProperty(name = "doneReceiveQuantity", value = "已入库数量")
    private BigDecimal doneReceiveQuantity;

    /**
     * 入库结果单号
     */
    @ApiModelProperty(name = "inResultNo", value = "入库结果单号")
    private String inResultNo;

    /**
     * 出库结果单号
     */
    @ApiModelProperty(name = "outResultNo", value = "出库结果单号")
    private String outResultNo;

    /**
     * 已出库数量
     */
    @ApiModelProperty(name = "doneDeliveryQuantity", value = "已出库数量")
    private BigDecimal doneDeliveryQuantity;



    /**
     * 生产日期 (冗余)
     **/
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

    /**
     * 过期日期 (冗余)
     **/
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getInResultNo() {
        return inResultNo;
    }

    public void setInResultNo(String inResultNo) {
        this.inResultNo = inResultNo;
    }

    public String getOutResultNo() {
        return outResultNo;
    }

    public void setOutResultNo(String outResultNo) {
        this.outResultNo = outResultNo;
    }

    public BigDecimal getDoneReceiveQuantity() {
        return doneReceiveQuantity;
    }

    public void setDoneReceiveQuantity(BigDecimal doneReceiveQuantity) {
        this.doneReceiveQuantity = doneReceiveQuantity;
    }

    public BigDecimal getDoneDeliveryQuantity() {
        return doneDeliveryQuantity;
    }

    public void setDoneDeliveryQuantity(BigDecimal doneDeliveryQuantity) {
        this.doneDeliveryQuantity = doneDeliveryQuantity;
    }
}
