package com.dtyunxi.yundt.cube.center.inventory.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 货品库存总表Eo对象
*
* @author songjiang.zxj
* @since 2021-10-21
*/
@ApiModel(value = "CargoStorageTotalReqDto", description = "货品库存总表Eo对象")
public class CargoStorageTotalReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
     *  渠道ID
     */
    @ApiModelProperty(name = "channelId", value = "渠道ID")
    private Long channelId;
    /**
    *  分组ID
    */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  仓位ID
    */
    @ApiModelProperty(name = "positionId", value = "仓位ID")
    private Long positionId;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *
    */
    @ApiModelProperty(name = "barCode", value = "")
    private String barCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  库存总数
    */
    @ApiModelProperty(name = "balance", value = "库存总数")
    private BigDecimal balance;
    /**
    *  预占
    */
    @ApiModelProperty(name = "preempt", value = "预占")
    private BigDecimal preempt;
    /**
    *  预留
    */
    @ApiModelProperty(name = "reserved", value = "预留")
    private BigDecimal reserved;
    /**
    *  可用
    */
    @ApiModelProperty(name = "available", value = "可用")
    private BigDecimal available;
    /**
    *  在途
    */
    @ApiModelProperty(name = "intransit", value = "在途")
    private BigDecimal intransit;
    /**
    *  期货库存
    */
    @ApiModelProperty(name = "futuresInventory", value = "期货库存")
    private Long futuresInventory;
    /**
    *  期货已发
    */
    @ApiModelProperty(name = "futuresIssued", value = "期货已发")
    private Long futuresIssued;
    /**
    *  待收
    */
    @ApiModelProperty(name = "pending", value = "待收")
    private Long pending;
    /**
    *  库存共享状态： 0 不开启 ，1 开启
    */
    @ApiModelProperty(name = "inventoryShareStatus", value = "库存共享状态： 0 不开启 ，1 开启")
    private Integer inventoryShareStatus;
    /**
    *  0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓
    */
    @ApiModelProperty(name = "warehouseType", value = "0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓")
    private String warehouseType;
    /**
    *  仓库子类型  物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS
    */
    @ApiModelProperty(name = "warehouseSubType", value = "仓库子类型  物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓(实际库存);逻辑仓：4 电商仓、5 经销商仓、6 门店仓(出入库);共享仓：7 平台电商共享仓、8 自营电商仓;渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS")
    private Integer warehouseSubType;
    /**
    *  残次品
    */
    @ApiModelProperty(name = "imperfections", value = "残次品")
    private Long imperfections;
    /**
    *  陪付品
    */
    @ApiModelProperty(name = "indemnity", value = "陪付品")
    private Long indemnity;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  营销云实时库存数量
    */
    @ApiModelProperty(name = "synNum", value = "营销云实时库存数量")
    private BigDecimal synNum;
    /**
    *  版本号
    */
    @ApiModelProperty(name = "version", value = "版本号")
    private Long version;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setGroupId(Long groupId){
    this.groupId = groupId;
    }
    public Long getGroupId(){
    return this.groupId;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setPositionId(Long positionId){
    this.positionId = positionId;
    }
    public Long getPositionId(){
    return this.positionId;
    }
    public void setCargoId(Long cargoId){
    this.cargoId = cargoId;
    }
    public Long getCargoId(){
    return this.cargoId;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBarCode(String barCode){
    this.barCode = barCode;
    }
    public String getBarCode(){
    return this.barCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setBalance(BigDecimal balance){
    this.balance = balance;
    }
    public BigDecimal getBalance(){
    return this.balance;
    }
    public void setPreempt(BigDecimal preempt){
    this.preempt = preempt;
    }
    public BigDecimal getPreempt(){
    return this.preempt;
    }
    public void setReserved(BigDecimal reserved){
    this.reserved = reserved;
    }
    public BigDecimal getReserved(){
    return this.reserved;
    }
    public void setAvailable(BigDecimal available){
    this.available = available;
    }
    public BigDecimal getAvailable(){
    return this.available;
    }
    public void setIntransit(BigDecimal intransit){
    this.intransit = intransit;
    }
    public BigDecimal getIntransit(){
    return this.intransit;
    }
    public void setFuturesInventory(Long futuresInventory){
    this.futuresInventory = futuresInventory;
    }
    public Long getFuturesInventory(){
    return this.futuresInventory;
    }
    public void setFuturesIssued(Long futuresIssued){
    this.futuresIssued = futuresIssued;
    }
    public Long getFuturesIssued(){
    return this.futuresIssued;
    }
    public void setPending(Long pending){
    this.pending = pending;
    }
    public Long getPending(){
    return this.pending;
    }
    public void setInventoryShareStatus(Integer inventoryShareStatus){
    this.inventoryShareStatus = inventoryShareStatus;
    }
    public Integer getInventoryShareStatus(){
    return this.inventoryShareStatus;
    }
    public void setWarehouseType(String warehouseType){
    this.warehouseType = warehouseType;
    }
    public String getWarehouseType(){
    return this.warehouseType;
    }
    public void setWarehouseSubType(Integer warehouseSubType){
    this.warehouseSubType = warehouseSubType;
    }
    public Integer getWarehouseSubType(){
    return this.warehouseSubType;
    }
    public void setImperfections(Long imperfections){
    this.imperfections = imperfections;
    }
    public Long getImperfections(){
    return this.imperfections;
    }
    public void setIndemnity(Long indemnity){
    this.indemnity = indemnity;
    }
    public Long getIndemnity(){
    return this.indemnity;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setExpireTime(Date expireTime){
    this.expireTime = expireTime;
    }
    public Date getExpireTime(){
    return this.expireTime;
    }
    public void setProduceTime(Date produceTime){
    this.produceTime = produceTime;
    }
    public Date getProduceTime(){
    return this.produceTime;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setSynNum(BigDecimal synNum){
    this.synNum = synNum;
    }
    public BigDecimal getSynNum(){
    return this.synNum;
    }
    public void setVersion(Long version){
    this.version = version;
    }
    public Long getVersion(){
    return this.version;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }
}
