package com.dtyunxi.yundt.cube.center.inventory.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class InventoryBizDateReqDto {

    @ApiModelProperty(name = "id", value = "单据ID")
    private Long id;

    @ApiModelProperty(name = "no", value = "单据编号")
    private String no;

    @NotBlank( message = "业务类型不能为空")
    @ApiModelProperty(name = "bizType", value = "业务类型")
    private String bizType;

    @NotNull( message = "业务时间不能为空")
    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;
}
