package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 *
 * 库存查询基础请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 10:49 上午
 */
public class CsInventoryBasicsPageQueryReqDto extends BasePageDto implements Serializable {

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库编码 */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "currentUserWarehouseIds", value = "当前用户对应仓库id")
    private List<Long> currentUserWarehouseIds;

    /**
     * 商品sku编码批量查询
     **/
    @ApiModelProperty(name = "skuCodeList", value = "商品sku编码批量查询")
    private List<String> skuCodeList;

    /**
     * 商品sku编码模糊查询
     **/
    @ApiModelProperty(name = "skuCodeLike", value = "商品sku编码模糊查询")
    private String skuCodeLike;

    /**
     * 商品sku编码精确查询
     **/
    @ApiModelProperty(name = "skuCode", value = "商品sku编码精确查询")
    private String skuCode;

    /**
     * 商品名称模糊查询
     **/
    @ApiModelProperty(name = "skuNameLike", value = "商品名称模糊查询")
    private String skuNameLike;

    /**
     * 商品名称精确查询
     **/
    @ApiModelProperty(name = "skuName", value = "商品名称精确查询")
    private String skuName;

    /**
     * 库存维度查询起始值
     **/
    @ApiModelProperty(name = "inventoryBegin", value = "库存维度查询起始值")
    private BigDecimal inventoryBegin;

    /**
     * 库存维度查询结束值
     **/
    @ApiModelProperty(name = "inventoryEnd", value = "库存维度查询结束值")
    private BigDecimal inventoryEnd;

    /**
     * 仓库编码批量查询
     **/
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码批量查询")
    private List<String> warehouseCodeList;

    /**
     * 批次号批量查询
     **/
    @ApiModelProperty(name = "batchList", value = "批次号批量查询")
    private List<String> batchList;

    /**
     * 货品长编码
     */
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public List<Long> getCurrentUserWarehouseIds() {
        return currentUserWarehouseIds;
    }

    public void setCurrentUserWarehouseIds(List<Long> currentUserWarehouseIds) {
        this.currentUserWarehouseIds = currentUserWarehouseIds;
    }

    public List<String> getSkuCodeList() {
        return skuCodeList;
    }

    public void setSkuCodeList(List<String> skuCodeList) {
        this.skuCodeList = skuCodeList;
    }

    public String getSkuCodeLike() {
        return skuCodeLike;
    }

    public void setSkuCodeLike(String skuCodeLike) {
        this.skuCodeLike = skuCodeLike;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuNameLike() {
        return skuNameLike;
    }

    public void setSkuNameLike(String skuNameLike) {
        this.skuNameLike = skuNameLike;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getInventoryBegin() {
        return inventoryBegin;
    }

    public void setInventoryBegin(BigDecimal inventoryBegin) {
        this.inventoryBegin = inventoryBegin;
    }

    public BigDecimal getInventoryEnd() {
        return inventoryEnd;
    }

    public void setInventoryEnd(BigDecimal inventoryEnd) {
        this.inventoryEnd = inventoryEnd;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }

    public List<String> getBatchList() {
        return batchList;
    }

    public void setBatchList(List<String> batchList) {
        this.batchList = batchList;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }
}
