package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCoverInventoryFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.YesNoEnum;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存基础出入库DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 2:25 下午
 */
public class CsInventoryInOutBasicsDto implements Serializable {

    /** 库存操作策略 **/
    @ApiModelProperty(name="strategy",value = "库存操作策略")
    private String strategy;

    /** 是否校验负库存  0-不校验，允许负库存     1-校验(默认)，不允许负库存 **/
    @ApiModelProperty(name="negativeValidate",value = "是否校验负库存  0-不校验(默认)，允许负库存     1-校验(默认)，不允许负库存")
    private Integer negativeValidate;

    /** 来源单据号 **/
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;

    /** 来源单据类型 **/
    @ApiModelProperty(name="sourceType",value = "来源单据类型")
    private String sourceType;

    /** 来源业务类型 **/
    @ApiModelProperty(name="businessType",value = "来源业务类型")
    private String businessType;

    /** 备注信息 **/
    @ApiModelProperty(name="remark",value = "备注信息")
    private String remark;

    /** 货品明细信息 **/
    @ApiModelProperty(name="basicDetailDtoList",value = "货品明细信息")
    private List<CsInventoryInOutBasicsCargoDto> inOutBasicsCargoDtoList;

    /** 出入库标识  in-入库  out-出库 */
    @ApiModelProperty(name="inOutFlag",value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;

    /** 是否覆盖原有库存 cover-覆盖  update-更新(默认)  */
    @ApiModelProperty(name="coverInventoryFlag",value = "是否覆盖原有库存 cover-覆盖  update-更新(默认)")
    private String coverInventoryFlag= CsInventoryCoverInventoryFlagEnum.UPDATE.getCode();

    /** 操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新 **/
    @ApiModelProperty(name="updateTotalFlag",value = "操作批次表的时候，是否同步更新总表  0-不更新（默认）  1-更新")
    private Integer updateTotalFlag = YesNoEnum.NO.getValue();

    /** 是否更新库存流水的可用库存，默认是需要更新，
     *  流水上除了发货扣减，可用库存不用变动，其他的都需要变动
     *
     *  0-不更新    1-更新（默认）
     *
     *  **/
    @ApiModelProperty(name="updateTotalFlag",value = "是否更新库存流水的可用库存，默认是需要更新，流水上除了发货扣减，可用库存不用变动，其他的都需要变动  0-不更新    1-更新（默认）")
    private Integer updateAvailableFlag = YesNoEnum.YES.getValue();

    /**
     * 操作版本来源，主要用于区分V1.0改造还是汤臣二期的  1-V1.0   2-二期
     */
    @ApiModelProperty(name="operateVersion",value = "操作版本来源，主要用于区分V1.0改造还是汤臣二期的  1-V1.0   2-二期")
    private Integer operateVersion;

    /** 库存释放后，是否需要将预占记录置为无效  true:默认需要释放     false:不释放 **/
    @ApiModelProperty(name="disablePreemptionFlag",value = "库存释放后，是否需要将预占记录置为无效  true:默认需要释放     false:不释放")
    private Boolean disablePreemptionFlag = true;

    /** 外部单号 */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    public CsInventoryInOutBasicsDto() {
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Integer getNegativeValidate() {
        return negativeValidate;
    }

    public void setNegativeValidate(Integer negativeValidate) {
        this.negativeValidate = negativeValidate;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<CsInventoryInOutBasicsCargoDto> getInOutBasicsCargoDtoList() {
        return inOutBasicsCargoDtoList;
    }

    public void setInOutBasicsCargoDtoList(List<CsInventoryInOutBasicsCargoDto> inOutBasicsCargoDtoList) {
        this.inOutBasicsCargoDtoList = inOutBasicsCargoDtoList;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public String getCoverInventoryFlag() {
        return coverInventoryFlag;
    }

    public void setCoverInventoryFlag(String coverInventoryFlag) {
        this.coverInventoryFlag = coverInventoryFlag;
    }

    public Integer getUpdateTotalFlag() {
        return updateTotalFlag;
    }

    public void setUpdateTotalFlag(Integer updateTotalFlag) {
        this.updateTotalFlag = updateTotalFlag;
    }

    public Integer getUpdateAvailableFlag() {
        return updateAvailableFlag;
    }

    public void setUpdateAvailableFlag(Integer updateAvailableFlag) {
        this.updateAvailableFlag = updateAvailableFlag;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Integer getOperateVersion() {
        return operateVersion;
    }

    public void setOperateVersion(Integer operateVersion) {
        this.operateVersion = operateVersion;
    }

    public Boolean getDisablePreemptionFlag() {
        return disablePreemptionFlag;
    }

    public void setDisablePreemptionFlag(Boolean disablePreemptionFlag) {
        this.disablePreemptionFlag = disablePreemptionFlag;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }
}
