package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * WMS发起取消DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsBasicsCancelReqDto", description = "WMS发起取消DTO")
public class CsBasicsCancelReqDto implements Serializable {

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 出/入库通知单号
     **/
    @ApiModelProperty(name = "noticeOrderNo", value = "出/入库通知单号")
    private String noticeOrderNo;

    /**
     * 备注字段
     **/
    @ApiModelProperty(name = "remark", value = "备注字段")
    private String remark;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型(内部使用)")
    private String businessType;
    /**
     * 业务单据表名
     */
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名(内部使用)")
    private String relevanceTableName;
    /**
     * 单据类型：out-出库通知单，in-入库通知单
     */
    @ApiModelProperty(name = "orderType", value = "单据类型：out-出库通知单，in-入库通知单(内部使用)")
    private String orderType;

    @ApiModelProperty(name = "onlyNodeCancel", value = "仅节点取消（不更新主单状态，不发通知）：true-是，false-否 默认否")
    private Boolean onlyNodeCancel=false;

    public Boolean getOnlyNodeCancel() {
        return onlyNodeCancel;
    }

    public void setOnlyNodeCancel(Boolean onlyNodeCancel) {
        this.onlyNodeCancel = onlyNodeCancel;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public CsBasicsCancelReqDto() {
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getNoticeOrderNo() {
        return noticeOrderNo;
    }

    public void setNoticeOrderNo(String noticeOrderNo) {
        this.noticeOrderNo = noticeOrderNo;
    }
}
