package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms;

import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsShippingInfoReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsBasicsReceiveReqDto", description = "基础的发货回传传入DTO")
public class CsBasicsReceiveReqDto implements Serializable {
    /**
     * wms订单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms订单号")
    private String wmsOrderNo;
    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 出入库通知单号
     **/
    @ApiModelProperty(name = "inOutNoticeOrderNo", value = "出入库通知单号")
    private String inOutNoticeOrderNo;
    /**
     * 出入库时间
     **/
    @ApiModelProperty(name = "inOutTime", value = "出入库时间")
    private Date inOutTime;
    /**
     * 预计到货时间
     **/
    @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
    private Date estimatedTime;
    /**
     * true:之前创建业务单据的时候，选择商品时，是没有批次的         false:之前创建业务单据的时候，选择商品时，是带有批次的
     **/
    @ApiModelProperty(name = "lackBatchFlag", value = "true:之前创建业务单据的时候，选择商品时，是没有批次的         false:之前创建业务单据的时候，选择商品时，是带有批次的")
    private Boolean lackBatchFlag;
    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsWmsBasicsDetailReqDto> detailReqDtoList;
    /**
     * 物流信息
     **/
    @ApiModelProperty(name = "shippingInfoReqDtoList", value = "物流信息")
    private List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList;

    @ApiModelProperty(name = "isAllDeal", value = "是否整单处理:1.是，0.否(整单处理表示只接收一次回传结果)")
    private Integer isAllDeal;

    @ApiModelProperty(name = "allowBatchChange", value = "允许批次变更：true.允许，false.不允许 （默认允许）")
    private Boolean allowBatchChange = true;
    @ApiModelProperty(name = "isHangUp", value = "是否需要挂起，默认不需要")
    private Boolean isHangUp = false;


    @ApiModelProperty(name = "enableAdjustInTransit", value = "是否需要调整在途(满足前提情况下)")
    private Boolean enableAdjustInTransit  = false;

    @ApiModelProperty(name = "adjustInTransitAutoAudit", value = "在途调整单是否自动审核")
    private Boolean adjustInTransitAutoAudit  = false;

    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    @ApiModelProperty(name = "shippingCompanyCode", value = "物流商编码")
    private String shippingCompanyCode;

    @ApiModelProperty(name = "shippingCompany", value = "物流商名称")
    private String shippingCompany;

    private Boolean ignoreHandUp = Boolean.FALSE;

    @ApiModelProperty(name = "extensionExternal", value = "外部扩展信息")
    private String extensionExternal;

    private String bizType;

    private Boolean isZeroDetailCount = Boolean.FALSE;

    public String getExtensionExternal() {
        return extensionExternal;
    }

    public void setExtensionExternal(String extensionExternal) {
        this.extensionExternal = extensionExternal;
    }

    public Boolean getHangUp() {
        return isHangUp;
    }

    public void setHangUp(Boolean hangUp) {
        isHangUp = hangUp;
    }

    public Boolean getAllowBatchChange() {
        return allowBatchChange;
    }

    public void setAllowBatchChange(Boolean allowBatchChange) {
        this.allowBatchChange = allowBatchChange;
    }

    public Integer getIsAllDeal() {
        return isAllDeal;
    }

    public void setIsAllDeal(Integer isAllDeal) {
        this.isAllDeal = isAllDeal;
    }

    public CsBasicsReceiveReqDto() {
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public List<CsWmsBasicsDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsWmsBasicsDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public String getInOutNoticeOrderNo() {
        return inOutNoticeOrderNo;
    }

    public void setInOutNoticeOrderNo(String inOutNoticeOrderNo) {
        this.inOutNoticeOrderNo = inOutNoticeOrderNo;
    }

    public Date getInOutTime() {
        return inOutTime;
    }

    public void setInOutTime(Date inOutTime) {
        this.inOutTime = inOutTime;
    }

    public Boolean getLackBatchFlag() {
        return lackBatchFlag;
    }

    public void setLackBatchFlag(Boolean lackBatchFlag) {
        this.lackBatchFlag = lackBatchFlag;
    }

    public List<CsWmsShippingInfoReqDto> getShippingInfoReqDtoList() {
        return shippingInfoReqDtoList;
    }

    public void setShippingInfoReqDtoList(List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList) {
        this.shippingInfoReqDtoList = shippingInfoReqDtoList;
    }

    public Date getEstimatedTime() {
        return estimatedTime;
    }

    public void setEstimatedTime(Date estimatedTime) {
        this.estimatedTime = estimatedTime;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public Boolean getEnableAdjustInTransit() {
        return enableAdjustInTransit;
    }

    public void setEnableAdjustInTransit(Boolean enableAdjustInTransit) {
        this.enableAdjustInTransit = enableAdjustInTransit;
    }

    public String getConsignmentNo() {
        return consignmentNo;
    }

    public void setConsignmentNo(String consignmentNo) {
        this.consignmentNo = consignmentNo;
    }

    public Boolean getAdjustInTransitAutoAudit() {
        return adjustInTransitAutoAudit;
    }

    public void setAdjustInTransitAutoAudit(Boolean adjustInTransitAutoAudit) {
        this.adjustInTransitAutoAudit = adjustInTransitAutoAudit;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public Boolean getIgnoreHandUp() {
        return ignoreHandUp;
    }

    public void setIgnoreHandUp(Boolean ignoreHandUp) {
        this.ignoreHandUp = ignoreHandUp;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public Boolean getZeroDetailCount() {
        return isZeroDetailCount;
    }

    public void setZeroDetailCount(Boolean zeroDetailCount) {
        isZeroDetailCount = zeroDetailCount;
    }
}
